/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.location.segmented;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocation;

@XStreamAlias(value="VrpHubSegmentLocation")
public class HubSegmentLocation
extends Location {
    protected Map<RoadSegmentLocation, Double> nearbyTravelDistanceMap;
    protected Map<HubSegmentLocation, Double> hubTravelDistanceMap;

    public HubSegmentLocation() {
    }

    public HubSegmentLocation(long id, double latitude, double longitude) {
        super(id, latitude, longitude);
    }

    public Map<RoadSegmentLocation, Double> getNearbyTravelDistanceMap() {
        return this.nearbyTravelDistanceMap;
    }

    public void setNearbyTravelDistanceMap(Map<RoadSegmentLocation, Double> nearbyTravelDistanceMap) {
        this.nearbyTravelDistanceMap = nearbyTravelDistanceMap;
    }

    public Map<HubSegmentLocation, Double> getHubTravelDistanceMap() {
        return this.hubTravelDistanceMap;
    }

    public void setHubTravelDistanceMap(Map<HubSegmentLocation, Double> hubTravelDistanceMap) {
        this.hubTravelDistanceMap = hubTravelDistanceMap;
    }

    @Override
    public int getDistance(Location location) {
        double distance = location instanceof RoadSegmentLocation ? this.getDistanceDouble((RoadSegmentLocation)location) : this.hubTravelDistanceMap.get((HubSegmentLocation)location).doubleValue();
        return (int)(distance * 1000.0 + 0.5);
    }

    public double getDistanceDouble(RoadSegmentLocation location) {
        Double distance = this.nearbyTravelDistanceMap.get(location);
        if (distance == null) {
            distance = this.getShortestDistanceDoubleThroughHub(location);
        }
        return distance;
    }

    protected double getShortestDistanceDoubleThroughHub(RoadSegmentLocation location) {
        double shortestDistance = Double.MAX_VALUE;
        for (HubSegmentLocation otherHub : location.getHubTravelDistanceMap().keySet()) {
            double d = this == otherHub ? 0.0 : this.hubTravelDistanceMap.get(otherHub);
            double distance = d + otherHub.nearbyTravelDistanceMap.get(location);
            if (!(distance < shortestDistance)) continue;
            shortestDistance = distance;
        }
        return shortestDistance;
    }
}

