/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.solver;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;

public class DepotDistanceCustomerDifficultyWeightFactory
implements SelectionSorterWeightFactory<VehicleRoutingSolution, Customer> {
    @Override
    public Comparable createSorterWeight(VehicleRoutingSolution vehicleRoutingSolution, Customer customer) {
        Depot depot = vehicleRoutingSolution.getDepotList().get(0);
        return new DepotDistanceCustomerDifficultyWeight(customer, customer.getLocation().getDistance(depot.getLocation()));
    }

    public static class DepotDistanceCustomerDifficultyWeight
    implements Comparable<DepotDistanceCustomerDifficultyWeight> {
        private final Customer customer;
        private final int depotDistance;

        public DepotDistanceCustomerDifficultyWeight(Customer customer, int depotDistance) {
            this.customer = customer;
            this.depotDistance = depotDistance;
        }

        @Override
        public int compareTo(DepotDistanceCustomerDifficultyWeight other) {
            return new CompareToBuilder().append(this.depotDistance, other.depotDistance).append(this.customer.getDemand(), other.customer.getDemand()).append(this.customer.getLocation().getLatitude(), other.customer.getLocation().getLatitude()).append(this.customer.getLocation().getLongitude(), other.customer.getLocation().getLongitude()).append((Object)this.customer.getId(), (Object)other.customer.getId()).toComparison();
        }
    }
}

