/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.impl.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreDefinition;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.MachineCapacity;
import org.optaplanner.examples.cheaptime.domain.PeriodPowerPrice;
import org.optaplanner.examples.cheaptime.domain.Resource;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.domain.TaskRequirement;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.persistence.xstream.impl.score.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="CtCheapTimeSolution")
public class CheapTimeSolution
extends AbstractPersistable
implements Solution<HardMediumSoftLongScore> {
    private int timeResolutionInMinutes;
    private int globalPeriodRangeFrom;
    private int globalPeriodRangeTo;
    private List<Resource> resourceList;
    private List<Machine> machineList;
    private List<MachineCapacity> machineCapacityList;
    private List<Task> taskList;
    private List<TaskRequirement> taskRequirementList;
    private List<PeriodPowerPrice> periodPowerPriceList;
    private List<TaskAssignment> taskAssignmentList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={HardMediumSoftLongScoreDefinition.class})
    private HardMediumSoftLongScore score;

    public int getTimeResolutionInMinutes() {
        return this.timeResolutionInMinutes;
    }

    public void setTimeResolutionInMinutes(int timeResolutionInMinutes) {
        this.timeResolutionInMinutes = timeResolutionInMinutes;
    }

    public int getGlobalPeriodRangeFrom() {
        return this.globalPeriodRangeFrom;
    }

    public void setGlobalPeriodRangeFrom(int globalPeriodRangeFrom) {
        this.globalPeriodRangeFrom = globalPeriodRangeFrom;
    }

    public int getGlobalPeriodRangeTo() {
        return this.globalPeriodRangeTo;
    }

    public void setGlobalPeriodRangeTo(int globalPeriodRangeTo) {
        this.globalPeriodRangeTo = globalPeriodRangeTo;
    }

    public List<Resource> getResourceList() {
        return this.resourceList;
    }

    @ValueRangeProvider(id="machineRange")
    public List<Machine> getMachineList() {
        return this.machineList;
    }

    public void setMachineList(List<Machine> machineList) {
        this.machineList = machineList;
    }

    public void setResourceList(List<Resource> resourceList) {
        this.resourceList = resourceList;
    }

    public List<MachineCapacity> getMachineCapacityList() {
        return this.machineCapacityList;
    }

    public void setMachineCapacityList(List<MachineCapacity> machineCapacityList) {
        this.machineCapacityList = machineCapacityList;
    }

    public List<Task> getTaskList() {
        return this.taskList;
    }

    public void setTaskList(List<Task> taskList) {
        this.taskList = taskList;
    }

    public List<TaskRequirement> getTaskRequirementList() {
        return this.taskRequirementList;
    }

    public void setTaskRequirementList(List<TaskRequirement> taskRequirementList) {
        this.taskRequirementList = taskRequirementList;
    }

    public List<PeriodPowerPrice> getPeriodPowerPriceList() {
        return this.periodPowerPriceList;
    }

    public void setPeriodPowerPriceList(List<PeriodPowerPrice> periodPowerPriceList) {
        this.periodPowerPriceList = periodPowerPriceList;
    }

    @PlanningEntityCollectionProperty
    public List<TaskAssignment> getTaskAssignmentList() {
        return this.taskAssignmentList;
    }

    public void setTaskAssignmentList(List<TaskAssignment> taskAssignmentList) {
        this.taskAssignmentList = taskAssignmentList;
    }

    @Override
    public HardMediumSoftLongScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(HardMediumSoftLongScore score) {
        this.score = score;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.addAll(this.resourceList);
        facts.addAll(this.machineList);
        facts.addAll(this.machineCapacityList);
        facts.addAll(this.taskList);
        facts.addAll(this.taskRequirementList);
        facts.addAll(this.periodPowerPriceList);
        return facts;
    }
}

