/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.facttemplates.FactTemplateObjectType;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.PatternBuilder;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.TypeDeclaration;

public class FactTemplateTypeConf
implements ObjectTypeConf,
Externalizable {
    private static final long serialVersionUID = 510L;
    private FactTemplate factTemplate;
    private ObjectTypeNode concreteObjectTypeNode;
    private ObjectTypeNode[] cache;
    private boolean tmsEnabled;
    EntryPointId entryPoint;

    public FactTemplateTypeConf() {
    }

    public FactTemplateTypeConf(EntryPointId entryPoint, FactTemplate factTemplate, InternalKnowledgeBase kBase) {
        this.factTemplate = factTemplate;
        this.entryPoint = entryPoint;
        FactTemplateObjectType objectType = new FactTemplateObjectType(factTemplate);
        this.concreteObjectTypeNode = kBase.getRete().getObjectTypeNodes(entryPoint).get(objectType);
        if (this.concreteObjectTypeNode == null) {
            BuildContext context = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
            if (context.getKnowledgeBase().getConfiguration().isSequential()) {
                context.setTupleMemoryEnabled(false);
                context.setObjectTypeNodeMemoryEnabled(false);
            } else {
                context.setTupleMemoryEnabled(true);
                context.setObjectTypeNodeMemoryEnabled(true);
            }
            this.concreteObjectTypeNode = PatternBuilder.attachObjectTypeNode(context, objectType);
        }
        this.cache = new ObjectTypeNode[]{this.concreteObjectTypeNode};
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.factTemplate = (FactTemplate)in.readObject();
        this.concreteObjectTypeNode = (ObjectTypeNode)in.readObject();
        this.cache = (ObjectTypeNode[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.factTemplate);
        out.writeObject(this.concreteObjectTypeNode);
        out.writeObject(this.cache);
    }

    @Override
    public ObjectTypeNode getConcreteObjectTypeNode() {
        return this.concreteObjectTypeNode;
    }

    @Override
    public ObjectTypeNode[] getObjectTypeNodes() {
        if (this.cache == null) {
            this.cache = new ObjectTypeNode[]{this.concreteObjectTypeNode};
        }
        return this.cache;
    }

    @Override
    public boolean isAssignableFrom(Object object) {
        return this.factTemplate.equals(object);
    }

    @Override
    public void resetCache() {
        this.cache = null;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean isTrait() {
        return false;
    }

    @Override
    public TypeDeclaration getTypeDeclaration() {
        return null;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isTMSEnabled() {
        return this.tmsEnabled;
    }

    @Override
    public boolean isTraitTMSEnabled() {
        return false;
    }

    @Override
    public void enableTMS() {
        this.tmsEnabled = true;
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public boolean isSupportsPropertyChangeListeners() {
        return false;
    }

    @Override
    public String getTypeName() {
        return this.factTemplate.getName();
    }
}

