/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.timewindowed.solver;

import org.apache.commons.lang.ObjectUtils;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;

public class ArrivalTimeUpdatingVariableListener
implements VariableListener<Customer> {
    @Override
    public void beforeEntityAdded(ScoreDirector scoreDirector, Customer customer) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector scoreDirector, Customer customer) {
        if (customer instanceof TimeWindowedCustomer) {
            this.updateVehicle(scoreDirector, (TimeWindowedCustomer)customer);
        }
    }

    @Override
    public void beforeVariableChanged(ScoreDirector scoreDirector, Customer customer) {
    }

    @Override
    public void afterVariableChanged(ScoreDirector scoreDirector, Customer customer) {
        if (customer instanceof TimeWindowedCustomer) {
            this.updateVehicle(scoreDirector, (TimeWindowedCustomer)customer);
        }
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector scoreDirector, Customer customer) {
    }

    @Override
    public void afterEntityRemoved(ScoreDirector scoreDirector, Customer customer) {
    }

    protected void updateVehicle(ScoreDirector scoreDirector, TimeWindowedCustomer sourceCustomer) {
        TimeWindowedCustomer shadowCustomer;
        Standstill previousStandstill = sourceCustomer.getPreviousStandstill();
        Integer departureTime = previousStandstill instanceof TimeWindowedCustomer ? ((TimeWindowedCustomer)previousStandstill).getDepartureTime() : null;
        Integer arrivalTime = this.calculateArrivalTime(shadowCustomer, departureTime);
        for (shadowCustomer = sourceCustomer; shadowCustomer != null && ObjectUtils.notEqual((Object)shadowCustomer.getArrivalTime(), (Object)arrivalTime); shadowCustomer = shadowCustomer.getNextCustomer()) {
            scoreDirector.beforeVariableChanged(shadowCustomer, "arrivalTime");
            shadowCustomer.setArrivalTime(arrivalTime);
            scoreDirector.afterVariableChanged(shadowCustomer, "arrivalTime");
            departureTime = shadowCustomer.getDepartureTime();
            arrivalTime = this.calculateArrivalTime(shadowCustomer, departureTime);
        }
    }

    private Integer calculateArrivalTime(TimeWindowedCustomer customer, Integer previousDepartureTime) {
        if (customer == null) {
            return null;
        }
        if (previousDepartureTime == null) {
            return Math.max(customer.getReadyTime(), customer.getDistanceFromPreviousStandstill());
        }
        return previousDepartureTime + customer.getDistanceFromPreviousStandstill();
    }
}

