/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.move;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.move.NoChangeMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class CompositeMove
extends AbstractMove {
    protected final List<Move> moveList;

    public static Move buildMove(List<Move> moveList) {
        int size = moveList.size();
        if (size > 1) {
            return new CompositeMove(moveList);
        }
        if (size == 1) {
            return moveList.get(0);
        }
        return new NoChangeMove();
    }

    public CompositeMove(List<Move> moveList) {
        this.moveList = moveList;
    }

    public List<Move> getMoveList() {
        return this.moveList;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (Move move : this.moveList) {
            if (move.isMoveDoable(scoreDirector)) continue;
            return false;
        }
        return true;
    }

    @Override
    public CompositeMove createUndoMove(ScoreDirector scoreDirector) {
        ArrayList<Move> undoMoveList = new ArrayList<Move>(this.moveList.size());
        for (Move move : this.moveList) {
            Move undoMove = move.createUndoMove(scoreDirector);
            undoMoveList.add(undoMove);
        }
        return new CompositeMove(Lists.reverse(undoMoveList));
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (Move move : this.moveList) {
            move.doMove(scoreDirector);
        }
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        TreeSet<String> childMoveTypeDescriptionSet = new TreeSet<String>();
        for (Move move : this.moveList) {
            childMoveTypeDescriptionSet.add(move.getSimpleMoveTypeDescription());
        }
        StringBuilder moveTypeDescription = new StringBuilder(20 * (this.moveList.size() + 1));
        moveTypeDescription.append(this.getClass().getSimpleName()).append("(");
        String delimiter = "";
        for (String childMoveTypeDescription : childMoveTypeDescriptionSet) {
            moveTypeDescription.append(delimiter).append("* ").append(childMoveTypeDescription);
            delimiter = ", ";
        }
        moveTypeDescription.append(")");
        return moveTypeDescription.toString();
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        LinkedHashSet<? extends Object> entities = new LinkedHashSet<Object>(this.moveList.size() * 2);
        for (Move move : this.moveList) {
            entities.addAll(move.getPlanningEntities());
        }
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        LinkedHashSet<? extends Object> values = new LinkedHashSet<Object>(this.moveList.size() * 2);
        for (Move move : this.moveList) {
            values.addAll(move.getPlanningValues());
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CompositeMove) {
            CompositeMove other = (CompositeMove)o;
            return ((Object)this.moveList).equals(other.moveList);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.moveList).hashCode();
    }

    public String toString() {
        return this.moveList.toString();
    }
}

