/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.forager.finalist;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.impl.localsearch.decider.forager.finalist.FinalistPodium;
import org.optaplanner.core.impl.localsearch.event.LocalSearchPhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFinalistPodium
extends LocalSearchPhaseLifecycleListenerAdapter
implements FinalistPodium {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean finalistIsAccepted;
    protected List<LocalSearchMoveScope> finalistList;

    @Override
    public void stepStarted(LocalSearchStepScope stepScope) {
        super.stepStarted(stepScope);
        this.finalistIsAccepted = false;
        this.finalistList = new ArrayList<LocalSearchMoveScope>(1024);
    }

    @Override
    public LocalSearchMoveScope pickMove(LocalSearchStepScope stepScope) {
        if (this.finalistList.isEmpty()) {
            return null;
        }
        if (this.finalistList.size() == 1) {
            return this.finalistList.get(0);
        }
        int randomIndex = stepScope.getWorkingRandom().nextInt(this.finalistList.size());
        return this.finalistList.get(randomIndex);
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.finalistIsAccepted = false;
        this.finalistList = null;
    }
}

