/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintMatchesDialog
extends JDialog {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SolutionBusiness solutionBusiness;

    public ConstraintMatchesDialog(SolverAndPersistenceFrame solverAndPersistenceFrame, SolutionBusiness solutionBusiness) {
        super(solverAndPersistenceFrame, "Constraint matches", true);
        this.solutionBusiness = solutionBusiness;
    }

    public void resetContentPanel() {
        if (!this.solutionBusiness.isConstraintMatchEnabled()) {
            this.setContentPane(new JLabel("Constraint matches are not supported with this ScoreDirector."));
        } else {
            final List<ConstraintMatchTotal> constraintMatchTotalList = this.solutionBusiness.getConstraintMatchTotalList();
            JSplitPane splitPane = new JSplitPane(0);
            final JTable table = new JTable(new ConstraintMatchTotalTableModel(constraintMatchTotalList));
            TableColumnModel columnModel = table.getColumnModel();
            columnModel.getColumn(0).setPreferredWidth(160);
            columnModel.getColumn(1).setPreferredWidth(300);
            columnModel.getColumn(2).setPreferredWidth(80);
            columnModel.getColumn(3).setPreferredWidth(80);
            columnModel.getColumn(4).setPreferredWidth(80);
            JScrollPane tableScrollPane = new JScrollPane(table);
            tableScrollPane.setPreferredSize(new Dimension(700, 300));
            splitPane.setTopComponent(tableScrollPane);
            JPanel bottomPanel = new JPanel(new BorderLayout());
            JLabel detailLabel = new JLabel("Constraint matches of selected constraint type");
            detailLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            bottomPanel.add((Component)detailLabel, "North");
            final JTextArea detailTextArea = new JTextArea(10, 80);
            JScrollPane detailScrollPane = new JScrollPane(detailTextArea);
            bottomPanel.add((Component)detailScrollPane, "Center");
            table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    int selectedRow = table.getSelectedRow();
                    if (selectedRow < 0) {
                        detailTextArea.setText("");
                    } else {
                        ConstraintMatchTotal constraintMatchTotal = (ConstraintMatchTotal)constraintMatchTotalList.get(selectedRow);
                        detailTextArea.setText(ConstraintMatchesDialog.this.buildConstraintMatchSetText(constraintMatchTotal));
                        detailTextArea.setCaretPosition(0);
                    }
                }
            });
            JPanel buttonPanel = new JPanel(new FlowLayout());
            AbstractAction okAction = new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConstraintMatchesDialog.this.setVisible(false);
                }
            };
            buttonPanel.add(new JButton(okAction));
            bottomPanel.add((Component)buttonPanel, "South");
            splitPane.setBottomComponent(bottomPanel);
            splitPane.setResizeWeight(1.0);
            this.setContentPane(splitPane);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public String buildConstraintMatchSetText(ConstraintMatchTotal constraintMatchTotal) {
        Set<? extends ConstraintMatch> constraintMatchSet = constraintMatchTotal.getConstraintMatchSet();
        StringBuilder text = new StringBuilder(constraintMatchSet.size() * 80);
        for (ConstraintMatch constraintMatch : constraintMatchSet) {
            text.append(constraintMatch.toString()).append("\n");
        }
        return text.toString();
    }

    public static class ConstraintMatchTotalTableModel
    extends AbstractTableModel {
        private List<ConstraintMatchTotal> constraintMatchTotalList;

        public ConstraintMatchTotalTableModel(List<ConstraintMatchTotal> constraintMatchTotalList) {
            this.constraintMatchTotalList = constraintMatchTotalList;
        }

        @Override
        public int getRowCount() {
            return this.constraintMatchTotalList.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Constraint package";
                }
                case 1: {
                    return "Constraint name";
                }
                case 2: {
                    return "Score level";
                }
                case 3: {
                    return "Match count";
                }
                case 4: {
                    return "Weight total";
                }
            }
            throw new IllegalStateException("The columnIndex (" + columnIndex + ") is invalid.");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return Integer.class;
                }
                case 4: {
                    return Number.class;
                }
            }
            throw new IllegalStateException("The columnIndex (" + columnIndex + ") is invalid.");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ConstraintMatchTotal constraintMatchTotal = this.constraintMatchTotalList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return constraintMatchTotal.getConstraintPackage();
                }
                case 1: {
                    return constraintMatchTotal.getConstraintName();
                }
                case 2: {
                    return constraintMatchTotal.getScoreLevel();
                }
                case 3: {
                    return constraintMatchTotal.getConstraintMatchCount();
                }
                case 4: {
                    return constraintMatchTotal.getWeightTotalAsNumber();
                }
            }
            throw new IllegalStateException("The columnIndex (" + columnIndex + ") is invalid.");
        }
    }
}

