/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.score.director;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.io.KieResources;
import org.kie.api.runtime.KieContainer;
import org.optaplanner.core.config.score.definition.ScoreDefinitionType;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.config.util.KeyAsElementMapConverter;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.buildin.bendable.BendableScoreDefinition;
import org.optaplanner.core.impl.score.buildin.bendablebigdecimal.BendableBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.bendablelong.BendableLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftdouble.HardSoftDoubleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftlong.HardSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simplebigdecimal.SimpleBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simpledouble.SimpleDoubleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simplelong.SimpleLongScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.core.impl.score.director.easy.EasyScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreCalculator;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreDirectorFactory;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="scoreDirectorFactory")
public class ScoreDirectorFactoryConfig {
    private static final Logger logger = LoggerFactory.getLogger(ScoreDirectorFactoryConfig.class);
    protected Class<? extends ScoreDefinition> scoreDefinitionClass = null;
    protected ScoreDefinitionType scoreDefinitionType = null;
    protected Integer bendableHardLevelsSize = null;
    protected Integer bendableSoftLevelsSize = null;
    protected Class<? extends EasyScoreCalculator> easyScoreCalculatorClass = null;
    protected Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass = null;
    @XStreamOmitField
    protected KieBase kieBase = null;
    @XStreamImplicit(itemFieldName="scoreDrl")
    protected List<String> scoreDrlList = null;
    @XStreamImplicit(itemFieldName="scoreDrlFile")
    protected List<File> scoreDrlFileList = null;
    @XStreamConverter(value=KeyAsElementMapConverter.class)
    protected Map<String, String> kieBaseConfigurationProperties = null;
    protected String initializingScoreTrend = null;
    @XStreamAlias(value="assertionScoreDirectorFactory")
    protected ScoreDirectorFactoryConfig assertionScoreDirectorFactory = null;

    public Class<? extends ScoreDefinition> getScoreDefinitionClass() {
        return this.scoreDefinitionClass;
    }

    public void setScoreDefinitionClass(Class<? extends ScoreDefinition> scoreDefinitionClass) {
        this.scoreDefinitionClass = scoreDefinitionClass;
    }

    public ScoreDefinitionType getScoreDefinitionType() {
        return this.scoreDefinitionType;
    }

    public void setScoreDefinitionType(ScoreDefinitionType scoreDefinitionType) {
        this.scoreDefinitionType = scoreDefinitionType;
    }

    public Integer getBendableHardLevelsSize() {
        return this.bendableHardLevelsSize;
    }

    public void setBendableHardLevelsSize(Integer bendableHardLevelsSize) {
        this.bendableHardLevelsSize = bendableHardLevelsSize;
    }

    public Integer getBendableSoftLevelsSize() {
        return this.bendableSoftLevelsSize;
    }

    public void setBendableSoftLevelsSize(Integer bendableSoftLevelsSize) {
        this.bendableSoftLevelsSize = bendableSoftLevelsSize;
    }

    public Class<? extends EasyScoreCalculator> getEasyScoreCalculatorClass() {
        return this.easyScoreCalculatorClass;
    }

    public void setEasyScoreCalculatorClass(Class<? extends EasyScoreCalculator> easyScoreCalculatorClass) {
        this.easyScoreCalculatorClass = easyScoreCalculatorClass;
    }

    public Class<? extends IncrementalScoreCalculator> getIncrementalScoreCalculatorClass() {
        return this.incrementalScoreCalculatorClass;
    }

    public void setIncrementalScoreCalculatorClass(Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass) {
        this.incrementalScoreCalculatorClass = incrementalScoreCalculatorClass;
    }

    public KieBase getKieBase() {
        return this.kieBase;
    }

    public void setKieBase(KieBase kieBase) {
        this.kieBase = kieBase;
    }

    public List<String> getScoreDrlList() {
        return this.scoreDrlList;
    }

    public void setScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList;
    }

    public List<File> getScoreDrlFileList() {
        return this.scoreDrlFileList;
    }

    public void setScoreDrlFileList(List<File> scoreDrlFileList) {
        this.scoreDrlFileList = scoreDrlFileList;
    }

    public Map<String, String> getKieBaseConfigurationProperties() {
        return this.kieBaseConfigurationProperties;
    }

    public void setKieBaseConfigurationProperties(Map<String, String> kieBaseConfigurationProperties) {
        this.kieBaseConfigurationProperties = kieBaseConfigurationProperties;
    }

    public String getInitializingScoreTrend() {
        return this.initializingScoreTrend;
    }

    public void setInitializingScoreTrend(String initializingScoreTrend) {
        this.initializingScoreTrend = initializingScoreTrend;
    }

    public ScoreDirectorFactoryConfig getAssertionScoreDirectorFactory() {
        return this.assertionScoreDirectorFactory;
    }

    public void setAssertionScoreDirectorFactory(ScoreDirectorFactoryConfig assertionScoreDirectorFactory) {
        this.assertionScoreDirectorFactory = assertionScoreDirectorFactory;
    }

    public InnerScoreDirectorFactory buildScoreDirectorFactory(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor) {
        ScoreDefinition scoreDefinition = this.buildScoreDefinition();
        return this.buildScoreDirectorFactory(environmentMode, solutionDescriptor, scoreDefinition);
    }

    protected InnerScoreDirectorFactory buildScoreDirectorFactory(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition) {
        AbstractScoreDirectorFactory scoreDirectorFactory = this.buildEasyScoreDirectorFactory();
        if (scoreDirectorFactory == null) {
            scoreDirectorFactory = this.buildIncrementalScoreDirectorFactory();
        }
        if (scoreDirectorFactory == null) {
            scoreDirectorFactory = this.buildDroolsScoreDirectorFactory();
        }
        scoreDirectorFactory.setSolutionDescriptor(solutionDescriptor);
        scoreDirectorFactory.setScoreDefinition(scoreDefinition);
        if (this.assertionScoreDirectorFactory != null) {
            if (this.assertionScoreDirectorFactory.getAssertionScoreDirectorFactory() != null) {
                throw new IllegalArgumentException("A assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") cannot have a non-null assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory.getAssertionScoreDirectorFactory() + ").");
            }
            if (this.assertionScoreDirectorFactory.getScoreDefinitionClass() != null || this.assertionScoreDirectorFactory.getScoreDefinitionType() != null) {
                throw new IllegalArgumentException("A assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") must reuse the scoreDefinition of its parent." + " It cannot have a non-null scoreDefinition* property.");
            }
            if (environmentMode.compareTo(EnvironmentMode.FAST_ASSERT) > 0) {
                throw new IllegalArgumentException("A non-null assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") requires an environmentMode (" + (Object)((Object)environmentMode) + ") of " + (Object)((Object)EnvironmentMode.FAST_ASSERT) + " or lower.");
            }
            scoreDirectorFactory.setAssertionScoreDirectorFactory(this.assertionScoreDirectorFactory.buildScoreDirectorFactory(EnvironmentMode.PRODUCTION, solutionDescriptor, scoreDefinition));
        }
        scoreDirectorFactory.setInitializingScoreTrend(InitializingScoreTrend.parseTrend(this.initializingScoreTrend == null ? InitializingScoreTrendLevel.ANY.name() : this.initializingScoreTrend, scoreDefinition.getLevelsSize()));
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            scoreDirectorFactory.setAssertClonedSolution(true);
        }
        return scoreDirectorFactory;
    }

    public ScoreDefinition buildScoreDefinition() {
        if (this.scoreDefinitionType != ScoreDefinitionType.BENDABLE && this.scoreDefinitionType != ScoreDefinitionType.BENDABLE_LONG && this.scoreDefinitionType != ScoreDefinitionType.BENDABLE_BIG_DECIMAL && (this.bendableHardLevelsSize != null || this.bendableSoftLevelsSize != null)) {
            throw new IllegalArgumentException("With scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") there must be no bendableHardLevelsSize (" + this.bendableHardLevelsSize + ") or bendableSoftLevelsSize (" + this.bendableSoftLevelsSize + ").");
        }
        if (!(this.scoreDefinitionType != ScoreDefinitionType.BENDABLE && this.scoreDefinitionType != ScoreDefinitionType.BENDABLE_LONG && this.scoreDefinitionType != ScoreDefinitionType.BENDABLE_BIG_DECIMAL || this.bendableHardLevelsSize != null && this.bendableSoftLevelsSize != null)) {
            throw new IllegalArgumentException("With scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") there must be a bendableHardLevelsSize (" + this.bendableHardLevelsSize + ") and a bendableSoftLevelsSize (" + this.bendableSoftLevelsSize + ").");
        }
        if (this.scoreDefinitionClass != null) {
            if (this.scoreDefinitionType != null || this.bendableHardLevelsSize != null || this.bendableSoftLevelsSize != null) {
                throw new IllegalStateException("With scoreDefinitionClass (" + this.scoreDefinitionClass + ") there must be no scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") or bendableHardLevelsSize (" + this.bendableHardLevelsSize + ") or bendableSoftLevelsSize (" + this.bendableSoftLevelsSize + ").");
            }
            return ConfigUtils.newInstance(this, "scoreDefinitionClass", this.scoreDefinitionClass);
        }
        if (this.scoreDefinitionType != null) {
            switch (this.scoreDefinitionType) {
                case SIMPLE: {
                    return new SimpleScoreDefinition();
                }
                case SIMPLE_LONG: {
                    return new SimpleLongScoreDefinition();
                }
                case SIMPLE_DOUBLE: {
                    return new SimpleDoubleScoreDefinition();
                }
                case SIMPLE_BIG_DECIMAL: {
                    return new SimpleBigDecimalScoreDefinition();
                }
                case HARD_SOFT: {
                    return new HardSoftScoreDefinition();
                }
                case HARD_SOFT_LONG: {
                    return new HardSoftLongScoreDefinition();
                }
                case HARD_SOFT_DOUBLE: {
                    return new HardSoftDoubleScoreDefinition();
                }
                case HARD_SOFT_BIG_DECIMAL: {
                    return new HardSoftBigDecimalScoreDefinition();
                }
                case HARD_MEDIUM_SOFT: {
                    return new HardMediumSoftScoreDefinition();
                }
                case HARD_MEDIUM_SOFT_LONG: {
                    return new HardMediumSoftLongScoreDefinition();
                }
                case BENDABLE: {
                    return new BendableScoreDefinition(this.bendableHardLevelsSize, this.bendableSoftLevelsSize);
                }
                case BENDABLE_LONG: {
                    return new BendableLongScoreDefinition(this.bendableHardLevelsSize, this.bendableSoftLevelsSize);
                }
                case BENDABLE_BIG_DECIMAL: {
                    return new BendableBigDecimalScoreDefinition(this.bendableHardLevelsSize, this.bendableSoftLevelsSize);
                }
            }
            throw new IllegalStateException("The scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") is not implemented.");
        }
        return new SimpleScoreDefinition();
    }

    private AbstractScoreDirectorFactory buildEasyScoreDirectorFactory() {
        if (this.easyScoreCalculatorClass != null) {
            EasyScoreCalculator easyScoreCalculator = ConfigUtils.newInstance(this, "easyScoreCalculatorClass", this.easyScoreCalculatorClass);
            return new EasyScoreDirectorFactory(easyScoreCalculator);
        }
        return null;
    }

    private AbstractScoreDirectorFactory buildIncrementalScoreDirectorFactory() {
        if (this.incrementalScoreCalculatorClass != null) {
            if (!IncrementalScoreCalculator.class.isAssignableFrom(this.incrementalScoreCalculatorClass)) {
                throw new IllegalArgumentException("The incrementalScoreCalculatorClass (" + this.incrementalScoreCalculatorClass + ") does not implement " + IncrementalScoreCalculator.class.getSimpleName() + ".");
            }
            return new IncrementalScoreDirectorFactory(this.incrementalScoreCalculatorClass);
        }
        return null;
    }

    private AbstractScoreDirectorFactory buildDroolsScoreDirectorFactory() {
        DroolsScoreDirectorFactory scoreDirectorFactory = new DroolsScoreDirectorFactory(this.buildKieBase());
        return scoreDirectorFactory;
    }

    private KieBase buildKieBase() {
        if (this.kieBase != null) {
            if (!ConfigUtils.isEmptyCollection(this.scoreDrlList) || !ConfigUtils.isEmptyCollection(this.scoreDrlFileList)) {
                throw new IllegalArgumentException("If kieBase is not null, the scoreDrlList (" + this.scoreDrlList + ") and the scoreDrlFileList (" + this.scoreDrlFileList + ") must be empty.");
            }
            if (this.kieBaseConfigurationProperties != null) {
                throw new IllegalArgumentException("If kieBase is not null, the kieBaseConfigurationProperties (" + this.kieBaseConfigurationProperties + ") must be null.");
            }
            return this.kieBase;
        }
        if (ConfigUtils.isEmptyCollection(this.scoreDrlList) && ConfigUtils.isEmptyCollection(this.scoreDrlFileList)) {
            throw new IllegalArgumentException("The scoreDrlList (" + this.scoreDrlList + ") and the scoreDrlFileList (" + this.scoreDrlFileList + ") cannot both be empty.");
        }
        KieServices kieServices = KieServices.Factory.get();
        KieResources kieResources = kieServices.getResources();
        KieFileSystem kieFileSystem = kieServices.newKieFileSystem();
        if (!ConfigUtils.isEmptyCollection(this.scoreDrlList)) {
            for (String scoreDrl : this.scoreDrlList) {
                if (scoreDrl == null) {
                    throw new IllegalArgumentException("The scoreDrl (" + scoreDrl + ") cannot be null.");
                }
                URL scoreDrlURL = this.getClass().getClassLoader().getResource(scoreDrl);
                if (scoreDrlURL == null) {
                    String errorMessage = "The scoreDrl (" + scoreDrl + ") does not exist as a classpath resource.";
                    if (scoreDrl.startsWith("/")) {
                        errorMessage = errorMessage + "\nAs from 6.1, a classpath resource should not start with a slash (/). A scoreDrl now adheres to ClassLoader.getResource(String). Remove the leading slash from the scoreDrl if you're upgrading from 6.0.";
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                kieFileSystem.write(kieResources.newClassPathResource(scoreDrl, "UTF-8"));
            }
        }
        if (!ConfigUtils.isEmptyCollection(this.scoreDrlFileList)) {
            for (File scoreDrlFile : this.scoreDrlFileList) {
                if (scoreDrlFile == null) {
                    throw new IllegalArgumentException("The scoreDrlFile (" + scoreDrlFile + ") cannot be null.");
                }
                if (!scoreDrlFile.exists()) {
                    throw new IllegalArgumentException("The scoreDrlFile (" + scoreDrlFile + ") does not exist.");
                }
                kieFileSystem.write(kieResources.newFileSystemResource(scoreDrlFile, "UTF-8"));
            }
        }
        KieBuilder kieBuilder = kieServices.newKieBuilder(kieFileSystem);
        kieBuilder.buildAll();
        Results results = kieBuilder.getResults();
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new IllegalStateException("There are errors in a score DRL:\n" + results.toString());
        }
        if (results.hasMessages(new Message.Level[]{Message.Level.WARNING})) {
            logger.warn("There are warning in a score DRL:\n" + results.toString());
        }
        KieContainer kieContainer = kieServices.newKieContainer(kieBuilder.getKieModule().getReleaseId());
        KieBaseConfiguration kieBaseConfiguration = kieServices.newKieBaseConfiguration();
        if (this.kieBaseConfigurationProperties != null) {
            for (Map.Entry<String, String> entry : this.kieBaseConfigurationProperties.entrySet()) {
                kieBaseConfiguration.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return kieContainer.newKieBase(kieBaseConfiguration);
    }

    public void inherit(ScoreDirectorFactoryConfig inheritedConfig) {
        if (this.scoreDefinitionClass == null && this.scoreDefinitionType == null && this.bendableHardLevelsSize == null && this.bendableSoftLevelsSize == null) {
            this.scoreDefinitionClass = inheritedConfig.getScoreDefinitionClass();
            this.scoreDefinitionType = inheritedConfig.getScoreDefinitionType();
            this.bendableHardLevelsSize = inheritedConfig.getBendableHardLevelsSize();
            this.bendableSoftLevelsSize = inheritedConfig.getBendableSoftLevelsSize();
        }
        this.easyScoreCalculatorClass = ConfigUtils.inheritOverwritableProperty(this.easyScoreCalculatorClass, inheritedConfig.getEasyScoreCalculatorClass());
        this.incrementalScoreCalculatorClass = ConfigUtils.inheritOverwritableProperty(this.incrementalScoreCalculatorClass, inheritedConfig.getIncrementalScoreCalculatorClass());
        this.kieBase = ConfigUtils.inheritOverwritableProperty(this.kieBase, inheritedConfig.getKieBase());
        this.scoreDrlList = ConfigUtils.inheritMergeableListProperty(this.scoreDrlList, inheritedConfig.getScoreDrlList());
        this.scoreDrlFileList = ConfigUtils.inheritMergeableListProperty(this.scoreDrlFileList, inheritedConfig.getScoreDrlFileList());
        this.kieBaseConfigurationProperties = ConfigUtils.inheritMergeableMapProperty(this.kieBaseConfigurationProperties, inheritedConfig.getKieBaseConfigurationProperties());
        this.initializingScoreTrend = ConfigUtils.inheritOverwritableProperty(this.initializingScoreTrend, inheritedConfig.getInitializingScoreTrend());
        this.assertionScoreDirectorFactory = ConfigUtils.inheritOverwritableProperty(this.assertionScoreDirectorFactory, inheritedConfig.getAssertionScoreDirectorFactory());
    }
}

