/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.IterableSelector;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class ChangeMoveSelector
extends GenericMoveSelector {
    protected final EntitySelector entitySelector;
    protected final ValueSelector valueSelector;
    protected final boolean randomSelection;
    protected final boolean chained;

    public ChangeMoveSelector(EntitySelector entitySelector, ValueSelector valueSelector, boolean randomSelection) {
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        GenuineVariableDescriptor variableDescriptor = valueSelector.getVariableDescriptor();
        this.chained = variableDescriptor.isChained();
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        if (this.chained) {
            SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
            SingletonInverseVariableSupply singletonInverseVariableSupply = supplyManager.demand(new SingletonInverseVariableDemand(this.valueSelector.getVariableDescriptor()));
        }
    }

    @Override
    public boolean isCountable() {
        return this.entitySelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.entitySelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        if (this.valueSelector instanceof IterableSelector) {
            return this.entitySelector.getSize() * ((IterableSelector)((Object)this.valueSelector)).getSize();
        }
        long size = 0L;
        Iterator<Object> it = this.entitySelector.endingIterator();
        while (it.hasNext()) {
            Object entity = it.next();
            size += this.valueSelector.getSize(entity);
        }
        return size;
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new OriginalChangeMoveIterator();
        }
        return new RandomChangeMoveIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ", " + this.valueSelector + ")";
    }

    private class RandomChangeMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private Iterator<Object> entityIterator;

        private RandomChangeMoveIterator() {
            this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
        }

        @Override
        protected Move createUpcomingSelection() {
            if (!this.entityIterator.hasNext()) {
                this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
                if (!this.entityIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
            }
            Object entity = this.entityIterator.next();
            Iterator<Object> valueIterator = ChangeMoveSelector.this.valueSelector.iterator(entity);
            int entityIteratorCreationCount = 0;
            while (!valueIterator.hasNext()) {
                if (!this.entityIterator.hasNext()) {
                    this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
                    if (++entityIteratorCreationCount >= 2) {
                        return (Move)this.noUpcomingSelection();
                    }
                }
                entity = this.entityIterator.next();
                valueIterator = ChangeMoveSelector.this.valueSelector.iterator(entity);
            }
            Object toValue = valueIterator.next();
            return ChangeMoveSelector.this.chained ? new ChainedChangeMove(entity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue) : new ChangeMove(entity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
        }
    }

    private class OriginalChangeMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private Iterator<Object> entityIterator;
        private Iterator<Object> valueIterator;
        private Object upcomingEntity;

        private OriginalChangeMoveIterator() {
            this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
            this.valueIterator = Iterators.emptyIterator();
        }

        @Override
        protected Move createUpcomingSelection() {
            while (!this.valueIterator.hasNext()) {
                if (!this.entityIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
                this.upcomingEntity = this.entityIterator.next();
                this.valueIterator = ChangeMoveSelector.this.valueSelector.iterator(this.upcomingEntity);
            }
            Object toValue = this.valueIterator.next();
            return ChangeMoveSelector.this.chained ? new ChainedChangeMove(this.upcomingEntity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue) : new ChangeMove(this.upcomingEntity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
        }
    }
}

