/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class TwoOptMove
extends AbstractMove {
    protected final GenuineVariableDescriptor variableDescriptor;
    protected final AnchorVariableSupply anchorVariableSupply;
    protected final Object leftEntity;
    protected final Object rightEntity;

    public TwoOptMove(GenuineVariableDescriptor variableDescriptor, AnchorVariableSupply anchorVariableSupply, Object leftEntity, Object rightEntity) {
        this.variableDescriptor = variableDescriptor;
        this.anchorVariableSupply = anchorVariableSupply;
        this.leftEntity = leftEntity;
        this.rightEntity = rightEntity;
    }

    public Object getLeftEntity() {
        return this.leftEntity;
    }

    public Object getRightEntity() {
        return this.rightEntity;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        Object rightValue;
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = this.variableDescriptor.getValue(this.rightEntity))) || ObjectUtils.equals((Object)this.leftEntity, (Object)rightValue) || ObjectUtils.equals((Object)this.rightEntity, (Object)leftValue)) {
            return false;
        }
        if (!this.variableDescriptor.isValueRangeEntityIndependent()) {
            Solution workingSolution;
            ValueRangeDescriptor valueRangeDescriptor = this.variableDescriptor.getValueRangeDescriptor();
            ValueRange<?> rightValueRange = valueRangeDescriptor.extractValueRange(workingSolution = scoreDirector.getWorkingSolution(), this.rightEntity);
            if (!rightValueRange.contains(leftValue)) {
                return false;
            }
            ValueRange<?> leftValueRange = valueRangeDescriptor.extractValueRange(workingSolution, this.leftEntity);
            if (!leftValueRange.contains(rightValue)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object rightAnchor;
        boolean sameAnchor;
        Object leftAnchor = this.anchorVariableSupply.getAnchor(this.leftEntity);
        boolean bl = sameAnchor = leftAnchor == (rightAnchor = this.anchorVariableSupply.getAnchor(this.rightEntity));
        if (!sameAnchor) {
            return new TwoOptMove(this.variableDescriptor, this.anchorVariableSupply, this.rightEntity, this.leftEntity);
        }
        boolean rightEntityIsLater = this.isRightEntityLater(rightAnchor, this.rightEntity);
        Object laterEntity = rightEntityIsLater ? this.rightEntity : this.leftEntity;
        return new TwoOptMove(this.variableDescriptor, this.anchorVariableSupply, laterEntity, this.variableDescriptor.getValue(laterEntity));
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        Object rightAnchor;
        Object leftAnchor = this.anchorVariableSupply.getAnchor(this.leftEntity);
        boolean sameAnchor = leftAnchor == (rightAnchor = this.anchorVariableSupply.getAnchor(this.rightEntity));
        Object oldLeftValue = this.variableDescriptor.getValue(this.leftEntity);
        Object oldRightValue = this.variableDescriptor.getValue(this.rightEntity);
        if (!sameAnchor) {
            scoreDirector.beforeVariableChanged(this.variableDescriptor, this.leftEntity);
            scoreDirector.beforeVariableChanged(this.variableDescriptor, this.rightEntity);
            this.variableDescriptor.setValue(this.leftEntity, oldRightValue);
            this.variableDescriptor.setValue(this.rightEntity, oldLeftValue);
            scoreDirector.afterVariableChanged(this.variableDescriptor, this.leftEntity);
            scoreDirector.afterVariableChanged(this.variableDescriptor, this.rightEntity);
        } else {
            boolean rightEntityIsLater = this.isRightEntityLater(rightAnchor, oldRightValue);
            Object firstEntity = rightEntityIsLater ? this.leftEntity : this.rightEntity;
            Object laterEntity = rightEntityIsLater ? this.rightEntity : this.leftEntity;
            Object oldFirstValue = rightEntityIsLater ? oldLeftValue : oldRightValue;
            Object oldLaterValue = rightEntityIsLater ? oldRightValue : oldLeftValue;
            scoreDirector.beforeVariableChanged(this.variableDescriptor, laterEntity);
            this.variableDescriptor.setValue(laterEntity, firstEntity);
            scoreDirector.beforeVariableChanged(this.variableDescriptor, firstEntity);
            Object entity = oldLaterValue;
            Object nextEntity = oldFirstValue;
            while (entity != firstEntity) {
                Object value = this.variableDescriptor.getValue(entity);
                scoreDirector.changeVariableFacade(this.variableDescriptor, entity, nextEntity);
                nextEntity = entity;
                entity = value;
            }
            scoreDirector.afterVariableChanged(this.variableDescriptor, laterEntity);
            this.variableDescriptor.setValue(firstEntity, nextEntity);
            scoreDirector.afterVariableChanged(this.variableDescriptor, firstEntity);
        }
    }

    protected boolean isRightEntityLater(Object rightAnchor, Object oldRightValue) {
        Object entity = oldRightValue;
        while (entity != rightAnchor) {
            if (entity == this.leftEntity) {
                return true;
            }
            entity = this.variableDescriptor.getValue(entity);
        }
        return false;
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftEntity, this.rightEntity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(2);
        values.add(this.variableDescriptor.getValue(this.leftEntity));
        values.add(this.variableDescriptor.getValue(this.rightEntity));
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TwoOptMove) {
            TwoOptMove other = (TwoOptMove)o;
            return new EqualsBuilder().append(this.leftEntity, other.leftEntity).append(this.rightEntity, other.rightEntity).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.leftEntity).append(this.rightEntity).toHashCode();
    }

    public String toString() {
        return this.leftEntity + " <=2opt=> " + this.rightEntity;
    }
}

