/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableDemand;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractOriginalSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractRandomSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.ListIterable;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.TwoOptMove;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class TwoOptMoveSelector
extends GenericMoveSelector {
    protected final EntitySelector leftEntitySelector;
    protected final EntitySelector rightEntitySelector;
    protected final GenuineVariableDescriptor variableDescriptor;
    protected final boolean randomSelection;
    protected AnchorVariableSupply anchorVariableSupply;

    public TwoOptMoveSelector(EntitySelector leftEntitySelector, EntitySelector rightEntitySelector, GenuineVariableDescriptor variableDescriptor, boolean randomSelection) {
        this.leftEntitySelector = leftEntitySelector;
        this.rightEntitySelector = rightEntitySelector;
        this.variableDescriptor = variableDescriptor;
        this.randomSelection = randomSelection;
        EntityDescriptor leftEntityDescriptor = leftEntitySelector.getEntityDescriptor();
        EntityDescriptor rightEntityDescriptor = rightEntitySelector.getEntityDescriptor();
        if (!leftEntityDescriptor.getEntityClass().equals(rightEntityDescriptor.getEntityClass())) {
            throw new IllegalStateException("The selector (" + this + ") has a leftEntitySelector's entityClass (" + leftEntityDescriptor.getEntityClass() + ") which is not equal to the rightEntitySelector's entityClass (" + rightEntityDescriptor.getEntityClass() + ").");
        }
        if (!variableDescriptor.isChained()) {
            throw new IllegalStateException("The selector (" + this + ")'s variableDescriptor (" + variableDescriptor + ") must be chained (" + variableDescriptor.isChained() + ").");
        }
        if (!variableDescriptor.getEntityDescriptor().getEntityClass().isAssignableFrom(leftEntityDescriptor.getEntityClass())) {
            throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor with a entityClass (" + variableDescriptor.getEntityDescriptor().getEntityClass() + ") which is not equal or a superclass to the leftEntitySelector's entityClass (" + leftEntityDescriptor.getEntityClass() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(leftEntitySelector);
        if (leftEntitySelector != rightEntitySelector) {
            this.phaseLifecycleSupport.addEventListener(rightEntitySelector);
        }
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.anchorVariableSupply = supplyManager.demand(new AnchorVariableDemand(this.variableDescriptor));
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
        this.anchorVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        return this.leftEntitySelector.isCountable() && this.rightEntitySelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.leftEntitySelector.isNeverEnding() || this.rightEntitySelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return AbstractOriginalSwapIterator.getSize(this.leftEntitySelector, this.rightEntitySelector);
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new AbstractOriginalSwapIterator<Move, Object>((ListIterable)this.leftEntitySelector, (ListIterable)this.rightEntitySelector){

                @Override
                protected Move newSwapSelection(Object leftSubSelection, Object rightSubSelection) {
                    return new TwoOptMove(TwoOptMoveSelector.this.variableDescriptor, TwoOptMoveSelector.this.anchorVariableSupply, leftSubSelection, rightSubSelection);
                }
            };
        }
        return new AbstractRandomSwapIterator<Move, Object>((Iterable)this.leftEntitySelector, (Iterable)this.rightEntitySelector){

            @Override
            protected Move newSwapSelection(Object leftSubSelection, Object rightSubSelection) {
                return new TwoOptMove(TwoOptMoveSelector.this.variableDescriptor, TwoOptMoveSelector.this.anchorVariableSupply, leftSubSelection, rightSubSelection);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftEntitySelector + ", " + this.rightEntitySelector + ")";
    }
}

