/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.descriptor;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningEntityProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.solution.cloner.PlanningCloneable;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.PropertyAccessor;
import org.optaplanner.core.impl.domain.common.ReflectionPropertyAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.cloner.FieldAccessingSolutionCloner;
import org.optaplanner.core.impl.domain.solution.cloner.PlanningCloneableSolutionCloner;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionDescriptor {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<? extends Solution> solutionClass;
    private final BeanInfo solutionBeanInfo;
    private SolutionCloner solutionCloner;
    private final Map<String, PropertyAccessor> propertyAccessorMap;
    private final Map<String, PropertyAccessor> entityPropertyAccessorMap;
    private final Map<String, PropertyAccessor> entityCollectionPropertyAccessorMap;
    private final Map<Class<?>, EntityDescriptor> entityDescriptorMap;
    private final List<Class<?>> reversedEntityClassList;
    private final Map<Class<?>, EntityDescriptor> lowestEntityDescriptorCache;

    public SolutionDescriptor(Class<? extends Solution> solutionClass) {
        this.solutionClass = solutionClass;
        try {
            this.solutionBeanInfo = Introspector.getBeanInfo(solutionClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("The solutionClass (" + solutionClass + ") is not a valid java bean.", e);
        }
        int mapSize = this.solutionBeanInfo.getPropertyDescriptors().length;
        this.propertyAccessorMap = new LinkedHashMap<String, PropertyAccessor>(mapSize);
        this.entityPropertyAccessorMap = new LinkedHashMap<String, PropertyAccessor>(mapSize);
        this.entityCollectionPropertyAccessorMap = new LinkedHashMap<String, PropertyAccessor>(mapSize);
        this.entityDescriptorMap = new LinkedHashMap(mapSize);
        this.reversedEntityClassList = new ArrayList(mapSize);
        this.lowestEntityDescriptorCache = new HashMap(mapSize);
    }

    public void addEntityDescriptor(EntityDescriptor entityDescriptor) {
        Class<?> entityClass = entityDescriptor.getEntityClass();
        for (Class<?> otherEntityClass : this.entityDescriptorMap.keySet()) {
            if (!entityClass.isAssignableFrom(otherEntityClass)) continue;
            throw new IllegalArgumentException("An earlier entityClass (" + otherEntityClass + ") should not be a subclass of a later entityClass (" + entityClass + "). Switch their declaration so superclasses are defined earlier.");
        }
        this.entityDescriptorMap.put(entityClass, entityDescriptor);
        this.reversedEntityClassList.add(0, entityClass);
        this.lowestEntityDescriptorCache.put(entityClass, entityDescriptor);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processSolutionAnnotations(descriptorPolicy);
        this.processMethodAnnotations(descriptorPolicy);
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processSolutionAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningSolution solutionAnnotation = this.solutionClass.getAnnotation(PlanningSolution.class);
        if (solutionAnnotation == null) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has been specified as a solution in the configuration," + " but does not have a " + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        this.processSolutionCloner(descriptorPolicy, solutionAnnotation);
    }

    private void processSolutionCloner(DescriptorPolicy descriptorPolicy, PlanningSolution solutionAnnotation) {
        Class<? extends SolutionCloner> solutionClonerClass = solutionAnnotation.solutionCloner();
        if (solutionClonerClass == PlanningSolution.NullSolutionCloner.class) {
            solutionClonerClass = null;
        }
        this.solutionCloner = solutionClonerClass != null ? ConfigUtils.newInstance(this, "solutionClonerClass", solutionClonerClass) : (PlanningCloneable.class.isAssignableFrom(this.solutionClass) ? new PlanningCloneableSolutionCloner() : new FieldAccessingSolutionCloner(this));
    }

    private void processMethodAnnotations(DescriptorPolicy descriptorPolicy) {
        for (Method method : this.solutionClass.getMethods()) {
            if (!method.isAnnotationPresent(ValueRangeProvider.class)) continue;
            descriptorPolicy.addFromSolutionValueRangeProvider(method);
        }
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        boolean noPlanningEntityPropertyAnnotation = true;
        for (PropertyDescriptor propertyDescriptor : this.solutionBeanInfo.getPropertyDescriptors()) {
            ReflectionPropertyAccessor propertyAccessor = new ReflectionPropertyAccessor(propertyDescriptor);
            this.propertyAccessorMap.put(propertyAccessor.getName(), propertyAccessor);
            Method propertyGetter = propertyAccessor.getReadMethod();
            if (propertyGetter == null) continue;
            if (propertyGetter.isAnnotationPresent(PlanningEntityProperty.class)) {
                noPlanningEntityPropertyAnnotation = false;
                this.entityPropertyAccessorMap.put(propertyAccessor.getName(), propertyAccessor);
                continue;
            }
            if (!propertyGetter.isAnnotationPresent(PlanningEntityCollectionProperty.class)) continue;
            noPlanningEntityPropertyAnnotation = false;
            if (!Collection.class.isAssignableFrom(propertyAccessor.getPropertyType())) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a PlanningEntityCollection annotated property (" + propertyAccessor.getName() + ") that does not return a Collection.");
            }
            this.entityCollectionPropertyAccessorMap.put(propertyAccessor.getName(), propertyAccessor);
        }
        if (noPlanningEntityPropertyAnnotation) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") should have at least 1 getter with a PlanningEntityCollection or PlanningEntityProperty" + " annotation.");
        }
    }

    public void afterAnnotationsProcessed(DescriptorPolicy descriptorPolicy) {
        for (EntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.linkInheritedEntityDescriptors(descriptorPolicy);
        }
        for (EntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.linkShadowSources(descriptorPolicy);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("    Model annotations parsed for Solution {}:", (Object)this.solutionClass.getSimpleName());
            for (Map.Entry entry : this.entityDescriptorMap.entrySet()) {
                EntityDescriptor entityDescriptor = (EntityDescriptor)entry.getValue();
                this.logger.trace("        Entity {}:", (Object)entityDescriptor.getEntityClass().getSimpleName());
                for (VariableDescriptor variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                    this.logger.trace("            Variable {} ({})", (Object)variableDescriptor.getVariableName(), (Object)(variableDescriptor instanceof GenuineVariableDescriptor ? "genuine" : "shadow"));
                }
            }
        }
    }

    public Class<? extends Solution> getSolutionClass() {
        return this.solutionClass;
    }

    public SolutionCloner getSolutionCloner() {
        return this.solutionCloner;
    }

    public Map<String, PropertyAccessor> getEntityPropertyAccessorMap() {
        return this.entityPropertyAccessorMap;
    }

    public Map<String, PropertyAccessor> getEntityCollectionPropertyAccessorMap() {
        return this.entityCollectionPropertyAccessorMap;
    }

    public PropertyAccessor getPropertyAccessor(String propertyName) {
        return this.propertyAccessorMap.get(propertyName);
    }

    public Set<Class<?>> getEntityClassSet() {
        return this.entityDescriptorMap.keySet();
    }

    public Collection<EntityDescriptor> getEntityDescriptors() {
        return this.entityDescriptorMap.values();
    }

    public Collection<EntityDescriptor> getGenuineEntityDescriptors() {
        ArrayList<EntityDescriptor> genuineEntityDescriptorList = new ArrayList<EntityDescriptor>(this.entityDescriptorMap.size());
        for (EntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            if (!entityDescriptor.hasAnyDeclaredGenuineVariableDescriptor()) continue;
            genuineEntityDescriptorList.add(entityDescriptor);
        }
        return genuineEntityDescriptorList;
    }

    public boolean hasEntityDescriptorStrict(Class<?> entityClass) {
        return this.entityDescriptorMap.containsKey(entityClass);
    }

    public EntityDescriptor getEntityDescriptorStrict(Class<?> entityClass) {
        return this.entityDescriptorMap.get(entityClass);
    }

    public boolean hasEntityDescriptor(Class<?> entitySubclass) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptor(entitySubclass);
        return entityDescriptor != null;
    }

    public EntityDescriptor findEntityDescriptorOrFail(Class<?> entitySubclass) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptor(entitySubclass);
        if (entityDescriptor == null) {
            throw new IllegalArgumentException("A planning entity is an instance of a entitySubclass (" + entitySubclass + ") that is not configured as a planning entity.\n" + "If that class (" + entitySubclass.getSimpleName() + ") (or superclass thereof) is not a entityClass (" + this.getEntityClassSet() + "), check your Solution implementation's annotated methods.\n" + "If it is, check your solver configuration.");
        }
        return entityDescriptor;
    }

    public EntityDescriptor findEntityDescriptor(Class<?> entitySubclass) {
        EntityDescriptor entityDescriptor = this.lowestEntityDescriptorCache.get(entitySubclass);
        if (entityDescriptor == null) {
            for (Class<?> entityClass : this.reversedEntityClassList) {
                if (!entityClass.isAssignableFrom(entitySubclass)) continue;
                entityDescriptor = this.entityDescriptorMap.get(entityClass);
                this.lowestEntityDescriptorCache.put(entitySubclass, entityDescriptor);
                break;
            }
        }
        return entityDescriptor;
    }

    public Collection<GenuineVariableDescriptor> getChainedVariableDescriptors() {
        ArrayList<GenuineVariableDescriptor> chainedVariableDescriptors = new ArrayList<GenuineVariableDescriptor>();
        for (EntityDescriptor entityDescriptor : this.entityDescriptorMap.values()) {
            for (GenuineVariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptors()) {
                if (!variableDescriptor.isChained()) continue;
                chainedVariableDescriptors.add(variableDescriptor);
            }
        }
        return chainedVariableDescriptors;
    }

    public GenuineVariableDescriptor findGenuineVariableDescriptor(Object entity, String variableName) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        return entityDescriptor.getGenuineVariableDescriptor(variableName);
    }

    public GenuineVariableDescriptor findGenuineVariableDescriptorOrFail(Object entity, String variableName) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getGenuineVariableDescriptor(variableName);
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(entityDescriptor.buildInvalidVariableNameExceptionMessage(variableName));
        }
        return variableDescriptor;
    }

    public VariableDescriptor findVariableDescriptor(Object entity, String variableName) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        return entityDescriptor.getVariableDescriptor(variableName);
    }

    public VariableDescriptor findVariableDescriptorOrFail(Object entity, String variableName) {
        EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        VariableDescriptor variableDescriptor = entityDescriptor.getVariableDescriptor(variableName);
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(entityDescriptor.buildInvalidVariableNameExceptionMessage(variableName));
        }
        return variableDescriptor;
    }

    public Collection<Object> getAllFacts(Solution solution) {
        ArrayList<Object> facts = new ArrayList<Object>();
        Collection<Object> problemFacts = solution.getProblemFacts();
        if (problemFacts == null) {
            throw new IllegalStateException("The solution (" + solution + ")'s method getProblemFacts() should never return null.");
        }
        facts.addAll(problemFacts);
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            facts.add(entity);
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                facts.add(entity);
            }
        }
        return facts;
    }

    public int getEntityCount(Solution solution) {
        int entityCount = 0;
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            ++entityCount;
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractEntityCollection(entityCollectionPropertyAccessor, solution);
            entityCount += entityCollection.size();
        }
        return entityCount;
    }

    public List<Object> getEntityList(Solution solution) {
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            entityList.add(entity);
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractEntityCollection(entityCollectionPropertyAccessor, solution);
            entityList.addAll(entityCollection);
        }
        return entityList;
    }

    public List<Object> getEntityListByEntityClass(Solution solution, Class<?> entityClass) {
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity;
            if (!entityPropertyAccessor.getPropertyType().isAssignableFrom(entityClass) || (entity = this.extractEntity(entityPropertyAccessor, solution)) == null || !entityClass.isInstance(entity)) continue;
            entityList.add(entity);
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                if (!entityClass.isInstance(entity)) continue;
                entityList.add(entity);
            }
        }
        return entityList;
    }

    public long getVariableCount(Solution solution) {
        long variableCount = 0L;
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            variableCount += entityDescriptor.getVariableCount();
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
                variableCount += entityDescriptor.getVariableCount();
            }
        }
        return variableCount;
    }

    public int getValueCount(Solution solution) {
        boolean valueCount = false;
        throw new UnsupportedOperationException("getValueCount is not yet supported - this blocks ValueRatioTabuSizeStrategy");
    }

    public long getProblemScale(Solution solution) {
        long problemScale = 0L;
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            problemScale += entityDescriptor.getProblemScale(solution, entity);
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
                problemScale += entityDescriptor.getProblemScale(solution, entity);
            }
        }
        return problemScale;
    }

    public int countUninitializedVariables(Solution solution) {
        int count = 0;
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            count += entityDescriptor.countUninitializedVariables(entity);
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
                count += entityDescriptor.countUninitializedVariables(entity);
            }
        }
        return count;
    }

    public boolean isInitialized(ScoreDirector scoreDirector, Solution solution) {
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            EntityDescriptor entityDescriptor;
            Object entity = this.extractEntity(entityPropertyAccessor, solution);
            if (entity == null || (entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass())).isInitialized(entity) || entityDescriptor.hasMovableEntitySelectionFilter() && !entityDescriptor.getMovableEntitySelectionFilter().accept(scoreDirector, entity)) continue;
            return false;
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
                if (entityDescriptor.isInitialized(entity) || entityDescriptor.hasMovableEntitySelectionFilter() && !entityDescriptor.getMovableEntitySelectionFilter().accept(scoreDirector, entity)) continue;
                return false;
            }
        }
        return true;
    }

    public int countReinitializableVariables(ScoreDirector scoreDirector, Solution solution) {
        int count = 0;
        for (PropertyAccessor entityPropertyAccessor : this.entityPropertyAccessorMap.values()) {
            Object entity = this.extractEntity(entityPropertyAccessor, solution);
            if (entity == null) continue;
            EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            count += entityDescriptor.countReinitializableVariables(scoreDirector, entity);
        }
        for (PropertyAccessor entityCollectionPropertyAccessor : this.entityCollectionPropertyAccessorMap.values()) {
            Collection<?> entityCollection = this.extractEntityCollection(entityCollectionPropertyAccessor, solution);
            for (Object entity : entityCollection) {
                EntityDescriptor entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
                count += entityDescriptor.countReinitializableVariables(scoreDirector, entity);
            }
        }
        return count;
    }

    private Object extractEntity(PropertyAccessor entityPropertyAccessor, Solution solution) {
        return entityPropertyAccessor.executeGetter(solution);
    }

    private Collection<?> extractEntityCollection(PropertyAccessor entityCollectionPropertyAccessor, Solution solution) {
        Collection entityCollection = (Collection)entityCollectionPropertyAccessor.executeGetter(solution);
        if (entityCollection == null) {
            throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ")'s entityCollectionProperty (" + entityCollectionPropertyAccessor.getName() + ") should never return null.");
        }
        return entityCollection;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.solutionClass.getName() + ")";
    }
}

