/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.dinnerparty.solver.solution.initializer;

import java.util.ArrayList;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.phase.custom.CustomPhaseCommand;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.dinnerparty.domain.DinnerParty;
import org.optaplanner.examples.dinnerparty.domain.Seat;
import org.optaplanner.examples.dinnerparty.domain.SeatDesignation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DinnerPartySolutionInitializer
implements CustomPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void changeWorkingSolution(ScoreDirector scoreDirector) {
        DinnerParty dinnerParty = (DinnerParty)scoreDirector.getWorkingSolution();
        this.initializeSeatDesignationList(scoreDirector, dinnerParty);
    }

    private void initializeSeatDesignationList(ScoreDirector scoreDirector, DinnerParty dinnerParty) {
        ArrayList<Seat> undesignatedSeatList = new ArrayList<Seat>(dinnerParty.getSeatList());
        for (SeatDesignation seatDesignation : dinnerParty.getSeatDesignationList()) {
            Score<SimpleScore> bestScore = SimpleScore.valueOf(Integer.MIN_VALUE);
            Seat bestSeat = null;
            for (Seat seat : undesignatedSeatList) {
                if (seatDesignation.getGuest().getGender() != seat.getRequiredGender()) continue;
                scoreDirector.beforeVariableChanged(seatDesignation, "seat");
                seatDesignation.setSeat(seat);
                scoreDirector.afterVariableChanged(seatDesignation, "seat");
                Score score = scoreDirector.calculateScore();
                if (score.compareTo(bestScore) <= 0) continue;
                bestScore = score;
                bestSeat = seat;
            }
            if (bestSeat == null) {
                throw new IllegalStateException("The bestSeat (" + bestSeat + ") cannot be null.");
            }
            scoreDirector.beforeVariableChanged(seatDesignation, "seat");
            seatDesignation.setSeat(bestSeat);
            scoreDirector.afterVariableChanged(seatDesignation, "seat");
            undesignatedSeatList.remove(bestSeat);
        }
    }
}

