/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.solver.score;

import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.examples.investment.domain.InvestmentSolution;

public class InvestmentEasyScoreCalculator
implements EasyScoreCalculator<InvestmentSolution> {
    public HardSoftLongScore calculateScore(InvestmentSolution solution) {
        long hardScore = 0L;
        long softScore = 0L;
        long squaredFemtosMaximum = solution.getParametrization().calculateSquaredStandardDeviationFemtosMaximum();
        long squaredFemtos = solution.calculateStandardDeviationSquaredFemtos();
        if (squaredFemtos > squaredFemtosMaximum) {
            hardScore -= squaredFemtos - squaredFemtosMaximum;
        }
        return HardSoftLongScore.valueOf(hardScore, softScore += solution.calculateExpectedReturnMicros());
    }
}

