/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.solver.move.PatientAdmissionMoveHelper;

public class BedChangeMove
extends AbstractMove {
    private BedDesignation bedDesignation;
    private Bed toBed;

    public BedChangeMove(BedDesignation bedDesignation, Bed toBed) {
        this.bedDesignation = bedDesignation;
        this.toBed = toBed;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.bedDesignation.getBed(), (Object)this.toBed);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new BedChangeMove(this.bedDesignation, this.bedDesignation.getBed());
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        PatientAdmissionMoveHelper.moveBed(scoreDirector, this.bedDesignation, this.toBed);
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.bedDesignation);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toBed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BedChangeMove) {
            BedChangeMove other = (BedChangeMove)o;
            return new EqualsBuilder().append((Object)this.bedDesignation, (Object)other.bedDesignation).append((Object)this.toBed, (Object)other.toBed).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.bedDesignation).append((Object)this.toBed).toHashCode();
    }

    public String toString() {
        return this.bedDesignation + " {" + this.bedDesignation.getBed() + " -> " + this.toBed + "}";
    }
}

