/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.domain.solver;

import java.util.HashMap;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.projectjobscheduling.domain.ExecutionMode;
import org.optaplanner.examples.projectjobscheduling.domain.ResourceRequirement;
import org.optaplanner.examples.projectjobscheduling.domain.Schedule;
import org.optaplanner.examples.projectjobscheduling.domain.resource.Resource;

public class ExecutionModeStrengthWeightFactory
implements SelectionSorterWeightFactory<Schedule, ExecutionMode> {
    @Override
    public Comparable createSorterWeight(Schedule schedule, ExecutionMode executionMode) {
        HashMap<Resource, Integer> requirementTotalMap = new HashMap<Resource, Integer>(executionMode.getResourceRequirementList().size());
        for (ResourceRequirement resourceRequirement : executionMode.getResourceRequirementList()) {
            requirementTotalMap.put(resourceRequirement.getResource(), 0);
        }
        for (ResourceRequirement resourceRequirement : schedule.getResourceRequirementList()) {
            Resource resource = resourceRequirement.getResource();
            Integer total = (Integer)requirementTotalMap.get(resource);
            if (total == null) continue;
            total = total + resourceRequirement.getRequirement();
            requirementTotalMap.put(resource, total);
        }
        double requirementDesirability = 0.0;
        for (ResourceRequirement resourceRequirement : executionMode.getResourceRequirementList()) {
            Resource resource = resourceRequirement.getResource();
            int total = (Integer)requirementTotalMap.get(resource);
            if (total <= resource.getCapacity()) continue;
            requirementDesirability += (double)(total - resource.getCapacity()) * (double)resourceRequirement.getRequirement() * (resource.isRenewable() ? 1.0 : 100.0);
        }
        return new ExecutionModeStrengthWeight(executionMode, requirementDesirability);
    }

    public static class ExecutionModeStrengthWeight
    implements Comparable<ExecutionModeStrengthWeight> {
        private final ExecutionMode executionMode;
        private final double requirementDesirability;

        public ExecutionModeStrengthWeight(ExecutionMode executionMode, double requirementDesirability) {
            this.executionMode = executionMode;
            this.requirementDesirability = requirementDesirability;
        }

        @Override
        public int compareTo(ExecutionModeStrengthWeight other) {
            return new CompareToBuilder().append(this.requirementDesirability, other.requirementDesirability).append((Object)this.executionMode.getId(), (Object)other.executionMode.getId()).toComparison();
        }
    }
}

