/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence.util;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingDao;

public class VehicleRoutingDistanceTypeComparison
extends LoggingMain {
    private final ScoreDirectorFactory scoreDirectorFactory;
    protected final VehicleRoutingDao vehicleRoutingDao = new VehicleRoutingDao();

    public static void main(String[] args) {
        new VehicleRoutingDistanceTypeComparison().compare("solved/tmp-p-belgium-n50-k10.xml", "solved/tmp-p-belgium-road-km-n50-k10.xml", "solved/tmp-p-belgium-road-time-n50-k10.xml");
    }

    public VehicleRoutingDistanceTypeComparison() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource("org/optaplanner/examples/vehiclerouting/solver/vehicleRoutingSolverConfig.xml");
        this.scoreDirectorFactory = solverFactory.buildSolver().getScoreDirectorFactory();
    }

    public void compare(String ... filePaths) {
        File[] files = new File[filePaths.length];
        for (int i = 0; i < filePaths.length; ++i) {
            File file = new File(this.vehicleRoutingDao.getDataDir(), filePaths[i]);
            if (!file.exists()) {
                throw new IllegalArgumentException("The file (" + file + ") does not exist.");
            }
            files[i] = file;
        }
        for (File varFile : files) {
            this.logger.info("  Results for {}:", (Object)varFile.getName());
            VehicleRoutingSolution variablesSolution = (VehicleRoutingSolution)this.vehicleRoutingDao.readSolution(varFile);
            for (File inputFile : files) {
                HardSoftLongScore score;
                if (inputFile == varFile) {
                    score = variablesSolution.getScore();
                } else {
                    VehicleRoutingSolution inputSolution = (VehicleRoutingSolution)this.vehicleRoutingDao.readSolution(inputFile);
                    this.applyVariables(inputSolution, variablesSolution);
                    score = inputSolution.getScore();
                }
                this.logger.info("    {} (according to {})", (Object)score.getSoftScore(), (Object)inputFile.getName());
            }
        }
    }

    private void applyVariables(VehicleRoutingSolution inputSolution, VehicleRoutingSolution varSolution) {
        List<Vehicle> inputVehicleList = inputSolution.getVehicleList();
        LinkedHashMap<Long, Vehicle> inputVehicleMap = new LinkedHashMap<Long, Vehicle>(inputVehicleList.size());
        for (Vehicle vehicle : inputVehicleList) {
            inputVehicleMap.put(vehicle.getId(), vehicle);
        }
        List<Customer> inputCustomerList = inputSolution.getCustomerList();
        LinkedHashMap<Long, Customer> inputCustomerMap = new LinkedHashMap<Long, Customer>(inputCustomerList.size());
        for (Customer customer : inputCustomerList) {
            inputCustomerMap.put(customer.getId(), customer);
        }
        for (Vehicle varVehicle : varSolution.getVehicleList()) {
            Vehicle inputVehicle = (Vehicle)inputVehicleMap.get(varVehicle.getId());
            Customer varNext = varVehicle.getNextCustomer();
            inputVehicle.setNextCustomer(varNext == null ? null : (Customer)inputCustomerMap.get(varNext.getId()));
        }
        for (Customer varCustomer : varSolution.getCustomerList()) {
            Customer inputCustomer = (Customer)inputCustomerMap.get(varCustomer.getId());
            Standstill varPrevious = varCustomer.getPreviousStandstill();
            inputCustomer.setPreviousStandstill((Standstill)((Object)(varPrevious == null ? null : (varPrevious instanceof Vehicle ? (AbstractPersistable)inputVehicleMap.get(((Vehicle)varPrevious).getId()) : (AbstractPersistable)inputCustomerMap.get(((Customer)varPrevious).getId())))));
            Customer varNext = varCustomer.getNextCustomer();
            inputCustomer.setNextCustomer(varNext == null ? null : (Customer)inputCustomerMap.get(varNext.getId()));
        }
        ScoreDirector scoreDirector = this.scoreDirectorFactory.buildScoreDirector();
        scoreDirector.setWorkingSolution(inputSolution);
        scoreDirector.calculateScore();
    }
}

