/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedMoveUtils;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChainReversingChangeMove
extends AbstractMove {
    private final SubChain subChain;
    private final GenuineVariableDescriptor variableDescriptor;
    private final Object toPlanningValue;

    public SubChainReversingChangeMove(SubChain subChain, GenuineVariableDescriptor variableDescriptor, Object toPlanningValue) {
        this.subChain = subChain;
        this.variableDescriptor = variableDescriptor;
        this.toPlanningValue = toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        if (this.subChain.getEntityList().contains(this.toPlanningValue)) {
            return false;
        }
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return !ObjectUtils.equals((Object)oldFirstValue, (Object)this.toPlanningValue);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return new SubChainReversingChangeMove(this.subChain.reverse(), this.variableDescriptor, oldFirstValue);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        ChainedMoveUtils.doReverseSubChainChange(scoreDirector, this.subChain, this.variableDescriptor, this.toPlanningValue);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return this.subChain.getEntityList();
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubChainReversingChangeMove) {
            SubChainReversingChangeMove other = (SubChainReversingChangeMove)o;
            return new EqualsBuilder().append((Object)this.subChain, (Object)other.subChain).append((Object)this.variableDescriptor.getVariableName(), (Object)other.variableDescriptor.getVariableName()).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.subChain).append((Object)this.variableDescriptor.getVariableName()).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return this.subChain.toDottedString() + " {" + oldFirstValue + " -reversing-> " + this.toPlanningValue + "}";
    }
}

