/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.domain.Row;

public class RowChangeMove
extends AbstractMove {
    private Queen queen;
    private Row toRow;

    public RowChangeMove(Queen queen, Row toRow) {
        this.queen = queen;
        this.toRow = toRow;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.queen.getRow(), (Object)this.toRow);
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new RowChangeMove(this.queen, this.queen.getRow());
    }

    public void doMove(ScoreDirector scoreDirector) {
        scoreDirector.beforeVariableChanged((Object)this.queen, "row");
        this.queen.setRow(this.toRow);
        scoreDirector.afterVariableChanged((Object)this.queen, "row");
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.queen);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toRow);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RowChangeMove) {
            RowChangeMove other = (RowChangeMove)((Object)o);
            return new EqualsBuilder().append((Object)this.queen, (Object)other.queen).append((Object)this.toRow, (Object)other.toRow).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.queen).append((Object)this.toRow).toHashCode();
    }

    public String toString() {
        return this.queen + " {" + this.queen.getRow() + " -> " + this.toRow + "}";
    }
}

