/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.single.constraintmatchtotalstepscore;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.PureSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.common.MillisecondsSpentNumberFormat;
import org.optaplanner.benchmark.impl.statistic.single.constraintmatchtotalstepscore.ConstraintMatchTotalStepScoreStatisticPoint;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.DefaultSolver;

@XStreamAlias(value="constraintMatchTotalStepScoreSingleStatistic")
public class ConstraintMatchTotalStepScoreSingleStatistic
extends PureSingleStatistic<ConstraintMatchTotalStepScoreStatisticPoint> {
    @XStreamOmitField
    private ConstraintMatchTotalStepScoreSingleStatisticListener listener = new ConstraintMatchTotalStepScoreSingleStatisticListener();
    @XStreamOmitField
    protected List<File> graphFileList = null;

    public ConstraintMatchTotalStepScoreSingleStatistic(SingleBenchmarkResult singleBenchmarkResult) {
        super(singleBenchmarkResult, SingleStatisticType.CONSTRAINT_MATCH_TOTAL_STEP_SCORE);
    }

    public List<File> getGraphFileList() {
        return this.graphFileList;
    }

    @Override
    public void open(Solver solver) {
        DefaultSolver defaultSolver = (DefaultSolver)solver;
        defaultSolver.setConstraintMatchEnabledPreference(true);
        defaultSolver.addPhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver solver) {
        ((DefaultSolver)solver).removePhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return ConstraintMatchTotalStepScoreStatisticPoint.buildCsvLine("timeMillisSpent", "constraintPackage", "constraintName", "scoreLevel", "constraintMatchCount", "weightTotal");
    }

    @Override
    protected ConstraintMatchTotalStepScoreStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new ConstraintMatchTotalStepScoreStatisticPoint(Long.valueOf(csvLine.get(0)), csvLine.get(1), csvLine.get(2), Integer.valueOf(csvLine.get(3)), Integer.valueOf(csvLine.get(4)), Double.valueOf(csvLine.get(5)));
    }

    @Override
    public void writeGraphFiles(BenchmarkReport benchmarkReport) {
        ArrayList constraintIdToWeightSeriesMapList = new ArrayList(15);
        for (ConstraintMatchTotalStepScoreStatisticPoint point : this.getPointList()) {
            String constraintId;
            XYSeries weightSeries;
            int scoreLevel = point.getScoreLevel();
            if (scoreLevel >= 15) continue;
            while (scoreLevel >= constraintIdToWeightSeriesMapList.size()) {
                constraintIdToWeightSeriesMapList.add(new LinkedHashMap());
            }
            LinkedHashMap<String, XYSeries> constraintIdToWeightSeriesMap = (LinkedHashMap<String, XYSeries>)constraintIdToWeightSeriesMapList.get(scoreLevel);
            if (constraintIdToWeightSeriesMap == null) {
                constraintIdToWeightSeriesMap = new LinkedHashMap<String, XYSeries>();
                constraintIdToWeightSeriesMapList.set(scoreLevel, constraintIdToWeightSeriesMap);
            }
            if ((weightSeries = (XYSeries)constraintIdToWeightSeriesMap.get(constraintId = point.getConstraintPackage() + ":" + point.getConstraintName())) == null) {
                weightSeries = new XYSeries((Comparable)((Object)(point.getConstraintName() + " weight")));
                constraintIdToWeightSeriesMap.put(constraintId, weightSeries);
            }
            long timeMillisSpent = point.getTimeMillisSpent();
            weightSeries.add((double)timeMillisSpent, point.getWeightTotal());
        }
        this.graphFileList = new ArrayList<File>(constraintIdToWeightSeriesMapList.size());
        for (int scoreLevelIndex = 0; scoreLevelIndex < constraintIdToWeightSeriesMapList.size(); ++scoreLevelIndex) {
            XYPlot plot = this.createPlot(benchmarkReport, scoreLevelIndex);
            XYStepRenderer renderer = new XYStepRenderer();
            plot.setRenderer((XYItemRenderer)renderer);
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            for (XYSeries series : ((Map)constraintIdToWeightSeriesMapList.get(scoreLevelIndex)).values()) {
                seriesCollection.addSeries(series);
            }
            plot.setDataset((XYDataset)seriesCollection);
            JFreeChart chart = new JFreeChart(this.singleBenchmarkResult.getName() + " constraint match total step score diff level " + scoreLevelIndex + " statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.graphFileList.add(this.writeChartToImageFile(chart, "ConstraintMatchTotalStepScoreStatisticLevel" + scoreLevelIndex));
        }
    }

    private XYPlot createPlot(BenchmarkReport benchmarkReport, int scoreLevelIndex) {
        Locale locale = benchmarkReport.getLocale();
        NumberAxis xAxis = new NumberAxis("Time spent");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpentNumberFormat(locale));
        NumberAxis yAxis = new NumberAxis("Constraint match total weight level " + scoreLevelIndex);
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        yAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }

    private class ConstraintMatchTotalStepScoreSingleStatisticListener
    extends PhaseLifecycleListenerAdapter {
        private boolean constraintMatchEnabled;

        private ConstraintMatchTotalStepScoreSingleStatisticListener() {
        }

        public void phaseStarted(AbstractPhaseScope phaseScope) {
            InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
            this.constraintMatchEnabled = scoreDirector.isConstraintMatchEnabled();
            if (!this.constraintMatchEnabled) {
                ConstraintMatchTotalStepScoreSingleStatistic.this.logger.warn("The singleStatistic ({}) cannot function properly because ConstraintMatches are not supported on the ScoreDirector.", (Object)ConstraintMatchTotalStepScoreSingleStatistic.this.singleStatisticType);
            }
        }

        public void stepEnded(AbstractStepScope stepScope) {
            if (stepScope instanceof LocalSearchStepScope) {
                this.localSearchStepEnded((LocalSearchStepScope)stepScope);
            }
        }

        private void localSearchStepEnded(LocalSearchStepScope stepScope) {
            if (this.constraintMatchEnabled) {
                long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpent();
                for (ConstraintMatchTotal constraintMatchTotal : stepScope.getScoreDirector().getConstraintMatchTotals()) {
                    ConstraintMatchTotalStepScoreSingleStatistic.this.pointList.add(new ConstraintMatchTotalStepScoreStatisticPoint(timeMillisSpent, constraintMatchTotal.getConstraintPackage(), constraintMatchTotal.getConstraintName(), constraintMatchTotal.getScoreLevel(), constraintMatchTotal.getConstraintMatchCount(), constraintMatchTotal.getWeightTotalAsNumber().doubleValue()));
                }
            }
        }
    }
}

