/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.variable.custom.CustomShadowVariableDemand;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class CustomShadowVariableDescriptor
extends ShadowVariableDescriptor {
    protected CustomShadowVariableDescriptor refVariableDescriptor;
    protected Class<? extends VariableListener> variableListenerClass;
    protected List<VariableDescriptor> sourceVariableDescriptorList;

    public CustomShadowVariableDescriptor(EntityDescriptor entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        CustomShadowVariable shadowVariableAnnotation = this.variableMemberAccessor.getAnnotation(CustomShadowVariable.class);
        PlanningVariableReference variableListenerRef = shadowVariableAnnotation.variableListenerRef();
        if (variableListenerRef.variableName().equals("")) {
            variableListenerRef = null;
        }
        this.variableListenerClass = shadowVariableAnnotation.variableListenerClass();
        if (this.variableListenerClass == CustomShadowVariable.NullVariableListener.class) {
            this.variableListenerClass = null;
        }
        Object[] sources = shadowVariableAnnotation.sources();
        if (variableListenerRef != null) {
            if (this.variableListenerClass != null || sources.length > 0) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a non-null variableListenerRef (" + variableListenerRef + "), so it can not have a variableListenerClass (" + this.variableListenerClass + ") nor any sources (" + Arrays.toString(sources) + ").");
            }
        } else {
            if (this.variableListenerClass == null) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") which lacks a variableListenerClass (" + this.variableListenerClass + ").");
            }
            if (sources.length < 1) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sources (" + Arrays.toString(sources) + ") which is empty.");
            }
        }
    }

    public boolean isRef() {
        return this.variableListenerClass == null;
    }

    @Override
    public void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        CustomShadowVariable shadowVariableAnnotation = this.variableMemberAccessor.getAnnotation(CustomShadowVariable.class);
        PlanningVariableReference variableListenerRef = shadowVariableAnnotation.variableListenerRef();
        if (variableListenerRef.variableName().equals("")) {
            variableListenerRef = null;
        }
        if (variableListenerRef != null) {
            EntityDescriptor refEntityDescriptor;
            Class<?> refEntityClass = variableListenerRef.entityClass();
            if (refEntityClass.equals(PlanningVariableReference.NullEntityClass.class)) {
                refEntityDescriptor = this.entityDescriptor;
            } else {
                refEntityDescriptor = this.entityDescriptor.getSolutionDescriptor().findEntityDescriptor(refEntityClass);
                if (refEntityDescriptor == null) {
                    throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a refEntityClass (" + refEntityClass + ") which is not a valid planning entity.");
                }
            }
            String refVariableName = variableListenerRef.variableName();
            VariableDescriptor uncastRefVariableDescriptor = refEntityDescriptor.getVariableDescriptor(refVariableName);
            if (uncastRefVariableDescriptor == null) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with refVariableName (" + refVariableName + ") which is not a valid planning variable on entityClass (" + refEntityDescriptor.getEntityClass() + ").\n" + this.entityDescriptor.buildInvalidVariableNameExceptionMessage(refVariableName));
            }
            if (!(uncastRefVariableDescriptor instanceof CustomShadowVariableDescriptor)) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with refVariable (" + uncastRefVariableDescriptor.getSimpleEntityAndVariableName() + ") that lacks a " + CustomShadowVariable.class.getSimpleName() + " annotation.");
            }
            this.refVariableDescriptor = (CustomShadowVariableDescriptor)uncastRefVariableDescriptor;
            if (this.refVariableDescriptor.isRef()) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with refVariable (" + this.refVariableDescriptor + ") that must not be a reference too.");
            }
        } else {
            CustomShadowVariable.Source[] sources = shadowVariableAnnotation.sources();
            this.sourceVariableDescriptorList = new ArrayList<VariableDescriptor>(sources.length);
            for (CustomShadowVariable.Source source : sources) {
                EntityDescriptor sourceEntityDescriptor;
                Class<?> sourceEntityClass = source.entityClass();
                if (sourceEntityClass.equals(CustomShadowVariable.Source.NullEntityClass.class)) {
                    sourceEntityDescriptor = this.entityDescriptor;
                } else {
                    sourceEntityDescriptor = this.entityDescriptor.getSolutionDescriptor().findEntityDescriptor(sourceEntityClass);
                    if (sourceEntityDescriptor == null) {
                        throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a sourceEntityClass (" + sourceEntityClass + ") which is not a valid planning entity.");
                    }
                }
                String sourceVariableName = source.variableName();
                VariableDescriptor sourceVariableDescriptor = sourceEntityDescriptor.getVariableDescriptor(sourceVariableName);
                if (sourceVariableDescriptor == null) {
                    throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a valid planning variable on entityClass (" + sourceEntityDescriptor.getEntityClass() + ").\n" + this.entityDescriptor.buildInvalidVariableNameExceptionMessage(sourceVariableName));
                }
                sourceVariableDescriptor.registerShadowVariableDescriptor(this);
                this.sourceVariableDescriptorList.add(sourceVariableDescriptor);
            }
        }
    }

    @Override
    public List<VariableDescriptor> getSourceVariableDescriptorList() {
        if (this.refVariableDescriptor != null) {
            return Collections.singletonList(this.refVariableDescriptor);
        }
        return this.sourceVariableDescriptorList;
    }

    @Override
    public Demand getProvidedDemand() {
        return new CustomShadowVariableDemand(this);
    }

    @Override
    public boolean hasVariableListener(InnerScoreDirector scoreDirector) {
        return this.refVariableDescriptor == null;
    }

    @Override
    public VariableListener buildVariableListener(InnerScoreDirector scoreDirector) {
        if (this.refVariableDescriptor != null) {
            throw new IllegalStateException("The shadowVariableDescriptor (" + this + ") references another shadowVariableDescriptor (" + this.refVariableDescriptor + ") so it cannot build a " + VariableListener.class.getSimpleName() + ".");
        }
        return ConfigUtils.newInstance(this, "variableListenerClass", this.variableListenerClass);
    }
}

