/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.commons.jci.readers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.core.util.IoUtils;

public class DiskResourceReader
implements ResourceReader {
    private final File root;
    private Map<String, Integer> filesHashing;

    public DiskResourceReader(File pRoot) {
        this.root = pRoot;
    }

    @Override
    public boolean isAvailable(String pResourceName) {
        return new File(this.root, pResourceName).exists();
    }

    @Override
    public byte[] getBytes(String pResourceName) {
        try {
            return IoUtils.readBytesFromInputStream((InputStream)new FileInputStream(new File(this.root, pResourceName)));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Collection<String> getFileNames() {
        ArrayList<String> list = new ArrayList<String>();
        this.list(this.root, list);
        return list;
    }

    @Override
    public void mark() {
        this.filesHashing = this.hashFiles();
    }

    @Override
    public Collection<String> getModifiedResourcesSinceLastMark() {
        HashSet<String> modifiedResources = new HashSet<String>();
        Map<String, Integer> newHashing = this.hashFiles();
        for (Map.Entry<String, Integer> entry : newHashing.entrySet()) {
            Integer oldHashing = this.filesHashing.get(entry.getKey());
            if (oldHashing != null && oldHashing.equals(entry.getValue())) continue;
            modifiedResources.add(entry.getKey());
        }
        for (String oldFile : this.filesHashing.keySet()) {
            if (newHashing.containsKey(oldFile)) continue;
            modifiedResources.add(oldFile);
        }
        return modifiedResources;
    }

    private Map<String, Integer> hashFiles() {
        HashMap<String, Integer> hashing = new HashMap<String, Integer>();
        for (String fileName : this.getFileNames()) {
            byte[] bytes = this.getBytes(fileName);
            if (bytes == null) continue;
            hashing.put(fileName, Arrays.hashCode(bytes));
        }
        return hashing;
    }

    public String[] list() {
        ArrayList files = new ArrayList();
        this.list(this.root, files);
        return files.toArray(new String[files.size()]);
    }

    private void list(File pFile, List pFiles) {
        if (pFile.isDirectory()) {
            File[] directoryFiles = pFile.listFiles();
            for (int i = 0; i < directoryFiles.length; ++i) {
                this.list(directoryFiles[i], pFiles);
            }
        } else {
            pFiles.add(pFile.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1));
        }
    }
}

