/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolutionDao
implements SolutionDao {
    public static final String DATA_DIR_SYSTEM_PROPERTY = "org.optaplanner.examples.dataDir";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String dirName;
    protected File dataDir;

    public AbstractSolutionDao(String dirName) {
        this.dirName = dirName;
        String dataDirPath = System.getProperty(DATA_DIR_SYSTEM_PROPERTY, "data/");
        this.dataDir = new File(dataDirPath, dirName);
        if (!this.dataDir.exists()) {
            throw new IllegalStateException("The directory dataDir (" + this.dataDir.getAbsolutePath() + ") does not exist.\n" + " Either the working directory should be set to the directory that contains the data directory" + " (which is not the data directory itself), or the system property " + DATA_DIR_SYSTEM_PROPERTY + " should be set properly.\n" + " The data directory is different in a git clone (optaplanner/optaplanner-examples/data)" + " and in a release zip (examples/sources/data).\n" + " In an IDE (IntelliJ, Eclipse, NetBeans), open the \"Run configuration\"" + " to change \"Working directory\" (or add the system property in \"VM options\").");
        }
    }

    @Override
    public String getDirName() {
        return this.dirName;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }
}

