/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpdateContext;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.LeftTupleSourceUtils;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;
import org.kie.api.definition.rule.Rule;

public abstract class AbstractTerminalNode
extends BaseNode
implements TerminalNode,
Externalizable {
    private LeftTupleSource tupleSource;
    private BitMask declaredMask = EmptyBitMask.get();
    private BitMask inferredMask = EmptyBitMask.get();
    private BitMask negativeMask = EmptyBitMask.get();

    public AbstractTerminalNode() {
    }

    public AbstractTerminalNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, LeftTupleSource source) {
        super(id, partitionId, partitionsEnabled);
        this.tupleSource = source;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.declaredMask = (BitMask)in.readObject();
        this.inferredMask = (BitMask)in.readObject();
        this.negativeMask = (BitMask)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.tupleSource);
        out.writeObject(this.declaredMask);
        out.writeObject(this.inferredMask);
        out.writeObject(this.negativeMask);
    }

    public void initDeclaredMask(BuildContext context) {
        if (!(this.unwrapTupleSource() instanceof LeftInputAdapterNode)) {
            this.setDeclaredMask(AllSetBitMask.get());
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        ObjectType objectType = pattern.getObjectType();
        if (!(objectType instanceof ClassObjectType)) {
            this.setDeclaredMask(AllSetBitMask.get());
            return;
        }
        Class<?> objectClass = ((ClassObjectType)objectType).getClassType();
        TypeDeclaration typeDeclaration = context.getKnowledgeBase().getTypeDeclaration(objectClass);
        if (typeDeclaration == null || !typeDeclaration.isPropertyReactive()) {
            this.setDeclaredMask(AllSetBitMask.get());
        } else {
            List<String> settableProperties = PropertySpecificUtil.getSettableProperties(context.getKnowledgeBase(), objectClass);
            this.setDeclaredMask(PropertySpecificUtil.calculatePositiveMask(pattern.getListenedProperties(), settableProperties));
            this.setNegativeMask(PropertySpecificUtil.calculateNegativeMask(pattern.getListenedProperties(), settableProperties));
        }
    }

    @Override
    public void initInferredMask() {
        LeftTupleSource leftTupleSource = this.unwrapTupleSource();
        if (leftTupleSource instanceof LeftInputAdapterNode && ((LeftInputAdapterNode)leftTupleSource).getParentObjectSource() instanceof AlphaNode) {
            AlphaNode alphaNode = (AlphaNode)((LeftInputAdapterNode)leftTupleSource).getParentObjectSource();
            this.setInferredMask(alphaNode.updateMask(this.getDeclaredMask()));
        } else {
            this.setInferredMask(this.getDeclaredMask());
        }
        this.setInferredMask(this.getInferredMask().resetAll(this.getNegativeMask()));
    }

    @Override
    public LeftTupleSource unwrapTupleSource() {
        return this.tupleSource instanceof FromNode ? this.tupleSource.getLeftTupleSource() : this.tupleSource;
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSourceUtils.doModifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory, this, this.getLeftInputOtnId(), this.inferredMask);
    }

    @Override
    public abstract RuleImpl getRule();

    @Override
    public PathMemory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        PathMemory pmem = new PathMemory(this);
        AbstractTerminalNode.initPathMemory(pmem, this.getLeftTupleSource(), null, wm, null);
        return pmem;
    }

    public static void initPathMemory(PathMemory pmem, LeftTupleSource tupleSource, LeftTupleSource startTupleSource, InternalWorkingMemory wm, RuleImpl removingRule) {
        int counter = 1;
        long allLinkedTestMask = 0L;
        int size = tupleSource.getSinkPropagator().size();
        if (size > 2) {
            ++counter;
        } else if (!(size != 2 || removingRule != null && tupleSource.isAssociatedWith((Rule)removingRule))) {
            ++counter;
        }
        ConditionalBranchNode cen = AbstractTerminalNode.getConditionalBranchNode(tupleSource);
        boolean updateBitInNewSegment = true;
        boolean updateAllLinkedTest = cen == null;
        boolean subnetworkBoundaryCrossed = false;
        while (tupleSource.getType() != 120) {
            if (!subnetworkBoundaryCrossed && tupleSource.getType() == 167) {
                updateAllLinkedTest = true;
            }
            if (updateAllLinkedTest && updateBitInNewSegment && NodeTypeEnums.isBetaNode(tupleSource) && 211 != tupleSource.getType()) {
                BetaNode bn = (BetaNode)tupleSource;
                if (bn.isRightInputIsRiaNode()) {
                    updateBitInNewSegment = false;
                    RightInputAdapterNode.RiaNodeMemory rnmem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)((Object)bn.getRightInput()));
                    if (rnmem.getRiaPathMemory().getAllLinkedMaskTest() != 0L) {
                        allLinkedTestMask |= 1L;
                    }
                } else if (191 != bn.getType() || ((NotNode)bn).isEmptyBetaConstraints()) {
                    updateBitInNewSegment = false;
                    allLinkedTestMask |= 1L;
                }
            }
            if (!SegmentUtilities.parentInSameSegment(tupleSource, removingRule)) {
                updateBitInNewSegment = true;
                allLinkedTestMask <<= 1;
                ++counter;
            }
            if ((tupleSource = tupleSource.getLeftTupleSource()) != startTupleSource) continue;
            subnetworkBoundaryCrossed = true;
            updateAllLinkedTest = false;
        }
        if (!subnetworkBoundaryCrossed) {
            allLinkedTestMask |= 1L;
        }
        pmem.setAllLinkedMaskTest(allLinkedTestMask);
        pmem.setSegmentMemories(new SegmentMemory[counter]);
    }

    private static ConditionalBranchNode getConditionalBranchNode(LeftTupleSource tupleSource) {
        ConditionalBranchNode cen = null;
        while (tupleSource.getType() != 120) {
            if (tupleSource.getType() == 167) {
                cen = (ConditionalBranchNode)tupleSource;
            }
            tupleSource = tupleSource.getLeftTupleSource();
        }
        return cen;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        RuleTerminalNodeLeftTuple peer = new RuleTerminalNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        this.getLeftTupleSource().removeTupleSink(this);
        this.tupleSource = null;
        return true;
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    @Override
    public BitMask getDeclaredMask() {
        return this.declaredMask;
    }

    @Override
    public BitMask getInferredMask() {
        return this.inferredMask;
    }

    @Override
    public BitMask getLeftInferredMask() {
        return this.inferredMask;
    }

    @Override
    public void setDeclaredMask(BitMask mask) {
        this.declaredMask = mask;
    }

    @Override
    public void setInferredMask(BitMask mask) {
        this.inferredMask = mask;
    }

    @Override
    public BitMask getNegativeMask() {
        return this.negativeMask;
    }

    @Override
    public void setNegativeMask(BitMask mask) {
        this.negativeMask = mask;
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.getLeftTupleSource().networkUpdated(updateContext);
    }

    @Override
    public boolean isInUse() {
        return false;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
    }
}

