/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.drools.core.common.BaseNode;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.phreak.AddRemoveRule;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.RuleBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.WindowDeclaration;
import org.kie.api.definition.rule.Rule;

public class ReteooBuilder
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private transient InternalKnowledgeBase kBase;
    private Map<String, BaseNode[]> rules;
    private Map<String, BaseNode[]> queries;
    private Map<String, WindowNode> namedWindows;
    private transient RuleBuilder ruleBuilder;
    private IdGenerator idGenerator;

    public ReteooBuilder() {
    }

    public ReteooBuilder(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
        this.rules = new HashMap<String, BaseNode[]>();
        this.queries = new HashMap<String, BaseNode[]>();
        this.namedWindows = new HashMap<String, WindowNode>();
        this.idGenerator = new IdGenerator(1);
        this.ruleBuilder = kBase.getConfiguration().getComponentFactory().getRuleBuilderFactory().newRuleBuilder();
    }

    public synchronized void addRule(RuleImpl rule) throws InvalidPatternException {
        List<TerminalNode> terminals = this.ruleBuilder.addRule(rule, this.kBase, this.idGenerator);
        BaseNode[] nodes = terminals.toArray(new BaseNode[terminals.size()]);
        this.rules.put(rule.getFullyQualifiedName(), nodes);
        if (rule.isQuery()) {
            this.queries.put(rule.getName(), nodes);
        }
    }

    public void addEntryPoint(String id) {
        this.ruleBuilder.addEntryPoint(id, this.kBase, this.idGenerator);
    }

    public synchronized void addNamedWindow(WindowDeclaration window) {
        WindowNode wnode = this.ruleBuilder.addWindowNode(window, this.kBase, this.idGenerator);
        this.namedWindows.put(window.getName(), wnode);
    }

    public WindowNode getWindowNode(String name) {
        return this.namedWindows.get(name);
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public synchronized BaseNode[] getTerminalNodes(RuleImpl rule) {
        return this.getTerminalNodes(rule.getFullyQualifiedName());
    }

    public synchronized BaseNode[] getTerminalNodes(String ruleName) {
        return this.rules.get(ruleName);
    }

    public synchronized BaseNode[] getTerminalNodesForQuery(String ruleName) {
        BaseNode[] nodes = this.queries.get(ruleName);
        return nodes != null ? nodes : this.getTerminalNodes(ruleName);
    }

    public synchronized Map<String, BaseNode[]> getTerminalNodes() {
        return this.rules;
    }

    public synchronized void removeRule(RuleImpl rule) {
        InternalWorkingMemory[] workingMemories = this.kBase.getWorkingMemories();
        RuleRemovalContext context = new RuleRemovalContext((Rule)rule);
        context.setKnowledgeBase(this.kBase);
        for (BaseNode node : this.rules.remove(rule.getFullyQualifiedName())) {
            this.removeTerminalNode(context, (TerminalNode)((Object)node), workingMemories);
        }
        if (rule.isQuery()) {
            this.queries.remove(rule.getName());
        }
    }

    public void removeTerminalNode(RuleRemovalContext context, TerminalNode tn, InternalWorkingMemory[] workingMemories) {
        if (this.kBase.getConfiguration().isPhreakEnabled()) {
            AddRemoveRule.removeRule(tn, workingMemories, this.kBase);
        }
        RuleTerminalNode.RTNCleanupAdapter adapter = null;
        if (!this.kBase.getConfiguration().isPhreakEnabled()) {
            if (tn instanceof RuleTerminalNode) {
                adapter = new RuleTerminalNode.RTNCleanupAdapter((RuleTerminalNode)tn);
            }
            context.setCleanupAdapter(adapter);
        }
        BaseNode node = (BaseNode)((Object)tn);
        HashSet<BaseNode> removedSources = new HashSet<BaseNode>();
        LinkedList<BaseNode> betaStack = new LinkedList<BaseNode>();
        LinkedList<BaseNode> alphaStack = new LinkedList<BaseNode>();
        LinkedList<BaseNode> stillInUse = new LinkedList<BaseNode>();
        boolean processRian = true;
        while (node != null) {
            this.removeNode(node, removedSources, alphaStack, betaStack, stillInUse, processRian, workingMemories, context);
            if (!betaStack.isEmpty()) {
                processRian = node.getType() == 71;
                node = betaStack.removeLast();
                continue;
            }
            if (!alphaStack.isEmpty()) {
                node = alphaStack.removeLast();
                continue;
            }
            node = null;
        }
        this.resetMasks(stillInUse);
    }

    private void removeNode(BaseNode node, Set<BaseNode> removedSources, LinkedList<BaseNode> alphaStack, LinkedList<BaseNode> betaStack, LinkedList<BaseNode> stillInUse, boolean processRian, InternalWorkingMemory[] workingMemories, RuleRemovalContext context) {
        BaseNode parent;
        if (!betaStack.isEmpty() && node == betaStack.getLast()) {
            return;
        }
        if (node.getType() == 10) {
            return;
        }
        if (node.isInUse()) {
            stillInUse.add(node);
        }
        if (node.getType() != 30 && node.getType() != 40 && !node.isInUse() && this.kBase.getConfiguration().isPhreakEnabled()) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                workingMemory.clearNodeMemory((MemoryFactory)((Object)node));
            }
        }
        if (NodeTypeEnums.isBetaNode(node)) {
            parent = ((LeftTupleSink)((Object)node)).getLeftTupleSource();
            node.remove(context, this, workingMemories);
            if (!((BetaNode)node).isRightInputIsRiaNode()) {
                alphaStack.addLast(((BetaNode)node).getRightInput());
            }
            if (processRian && ((BetaNode)node).isRightInputIsRiaNode()) {
                betaStack.addLast(((BetaNode)node).getLeftTupleSource());
                betaStack.addLast(((BetaNode)node).getRightInput());
            } else {
                this.removeNode(parent, removedSources, alphaStack, betaStack, stillInUse, true, workingMemories, context);
            }
        } else if (NodeTypeEnums.isLeftTupleSink(node)) {
            parent = ((LeftTupleSink)((Object)node)).getLeftTupleSource();
            node.remove(context, this, workingMemories);
            this.removeNode(parent, removedSources, alphaStack, betaStack, stillInUse, true, workingMemories, context);
        } else if (120 == node.getType()) {
            parent = ((LeftInputAdapterNode)node).getParentObjectSource();
            node.remove(context, this, workingMemories);
            this.removeNode(parent, removedSources, alphaStack, betaStack, stillInUse, true, workingMemories, context);
        } else if (NodeTypeEnums.isObjectSource(node)) {
            if (!removedSources.contains(node)) {
                parent = ((ObjectSource)node).getParentObjectSource();
                if (node.remove(context, this, workingMemories)) {
                    removedSources.add(node);
                }
                this.removeNode(parent, removedSources, alphaStack, betaStack, stillInUse, true, workingMemories, context);
            }
        } else {
            throw new IllegalStateException("Defensive exception, should not fall through");
        }
    }

    public void resetMasks(List<BaseNode> nodes) {
        NodeSet leafSet = new NodeSet();
        for (BaseNode node : nodes) {
            RuleTerminalNode rtNode;
            if (node.getType() == 40) {
                this.updateLeafSet(node, leafSet);
                continue;
            }
            if (NodeTypeEnums.isBetaNode(node)) {
                BetaNode betaNode = (BetaNode)node;
                if (!betaNode.isInUse()) continue;
                leafSet.add(betaNode);
                continue;
            }
            if (!NodeTypeEnums.isTerminalNode(node) || !(rtNode = (RuleTerminalNode)node).isInUse()) continue;
            leafSet.add(rtNode);
        }
        for (BaseNode node : leafSet) {
            if (NodeTypeEnums.isTerminalNode(node)) {
                ((TerminalNode)((Object)node)).initInferredMask();
                continue;
            }
            ((BetaNode)node).initInferredMask();
        }
    }

    private void updateLeafSet(BaseNode baseNode, NodeSet leafSet) {
        if (baseNode.getType() == 40) {
            ((AlphaNode)baseNode).resetInferredMask();
            for (ObjectSink sink : ((AlphaNode)baseNode).getSinkPropagator().getSinks()) {
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (baseNode.getType() == 120) {
            for (LeftTupleSink sink : ((LeftInputAdapterNode)baseNode).getSinkPropagator().getSinks()) {
                if (sink.getType() == 101) {
                    leafSet.add((BaseNode)((Object)sink));
                    continue;
                }
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (baseNode.getType() == 131) {
            for (LeftTupleSink sink : ((EvalConditionNode)baseNode).getSinkPropagator().getSinks()) {
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (NodeTypeEnums.isBetaNode(baseNode) && baseNode.isInUse()) {
            leafSet.add(baseNode);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        DroolsObjectOutputStream droolsStream;
        ByteArrayOutputStream bytes;
        boolean isDrools = out instanceof DroolsObjectOutputStream;
        if (isDrools) {
            bytes = null;
            droolsStream = (DroolsObjectOutputStream)out;
        } else {
            bytes = new ByteArrayOutputStream();
            droolsStream = new DroolsObjectOutputStream(bytes);
        }
        droolsStream.writeObject(this.rules);
        droolsStream.writeObject(this.queries);
        droolsStream.writeObject(this.namedWindows);
        droolsStream.writeObject(this.idGenerator);
        if (!isDrools) {
            droolsStream.flush();
            droolsStream.close();
            bytes.close();
            out.writeInt(bytes.size());
            out.writeObject(bytes.toByteArray());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        DroolsObjectInputStream droolsStream;
        ByteArrayInputStream bytes;
        boolean isDrools = in instanceof DroolsObjectInputStream;
        if (isDrools) {
            bytes = null;
            droolsStream = (DroolsObjectInputStream)in;
        } else {
            bytes = new ByteArrayInputStream((byte[])in.readObject());
            droolsStream = new DroolsObjectInputStream(bytes);
        }
        this.rules = (Map)droolsStream.readObject();
        this.queries = (Map)droolsStream.readObject();
        this.namedWindows = (Map)droolsStream.readObject();
        this.idGenerator = (IdGenerator)droolsStream.readObject();
        if (!isDrools) {
            droolsStream.close();
            bytes.close();
        }
    }

    public void setRuleBase(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
        this.ruleBuilder = kBase.getConfiguration().getComponentFactory().getRuleBuilderFactory().newRuleBuilder();
    }

    public static class IdGenerator
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        private Queue<Integer> recycledIds;
        private int nextId;

        public IdGenerator() {
        }

        public IdGenerator(int firstId) {
            this.nextId = firstId;
            this.recycledIds = new LinkedList<Integer>();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.recycledIds = (Queue)in.readObject();
            this.nextId = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.recycledIds);
            out.writeInt(this.nextId);
        }

        public synchronized int getNextId() {
            int n;
            Integer id = this.recycledIds.poll();
            if (id == null) {
                int n2 = this.nextId;
                n = n2;
                this.nextId = n2 + 1;
            } else {
                n = id;
            }
            return n;
        }

        public synchronized void releaseId(int id) {
            this.recycledIds.add(id);
        }

        public int getLastId() {
            return this.nextId - 1;
        }
    }
}

