/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint.primdouble;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.primdouble.DoubleConstraintMatch;

public class DoubleConstraintMatchTotal
extends ConstraintMatchTotal {
    protected final Set<DoubleConstraintMatch> constraintMatchSet = new LinkedHashSet<DoubleConstraintMatch>();
    protected double weightTotal = 0.0;

    public DoubleConstraintMatchTotal(String constraintPackage, String constraintName, int scoreLevel) {
        super(constraintPackage, constraintName, scoreLevel);
    }

    public Set<DoubleConstraintMatch> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    public double getWeightTotal() {
        return this.weightTotal;
    }

    @Override
    public Number getWeightTotalAsNumber() {
        return this.weightTotal;
    }

    public DoubleConstraintMatch addConstraintMatch(RuleContext kcontext, double weight) {
        List<Object> justificationList = this.extractJustificationList(kcontext);
        return this.addConstraintMatch(justificationList, weight);
    }

    public DoubleConstraintMatch addConstraintMatch(List<Object> justificationList, double weight) {
        this.weightTotal += weight;
        DoubleConstraintMatch constraintMatch = new DoubleConstraintMatch(this.constraintPackage, this.constraintName, this.scoreLevel, justificationList, weight);
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (!added) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not add constraintMatch (" + constraintMatch + ") to its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
        return constraintMatch;
    }

    public void removeConstraintMatch(DoubleConstraintMatch constraintMatch) {
        this.weightTotal -= constraintMatch.getWeight();
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }
}

