/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.AirLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.DistanceType;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.HubSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedDepot;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingDao;

public class VehicleRoutingImporter
extends AbstractTxtSolutionImporter {
    public static void main(String[] args) {
        VehicleRoutingImporter importer = new VehicleRoutingImporter();
        importer.convert("vrpweb/basic/air/A-n33-k6.vrp", "cvrp-32customers.xml");
        importer.convert("vrpweb/basic/air/A-n55-k9.vrp", "cvrp-54customers.xml");
        importer.convert("vrpweb/basic/air/F-n72-k4.vrp", "cvrp-72customers.xml");
        importer.convert("vrpweb/timewindowed/air/Solomon_025_C101.vrp", "cvrptw-25customers.xml");
        importer.convert("vrpweb/timewindowed/air/Solomon_100_R101.vrp", "cvrptw-100customers-A.xml");
        importer.convert("vrpweb/timewindowed/air/Solomon_100_R201.vrp", "cvrptw-100customers-B.xml");
        importer.convert("vrpweb/timewindowed/air/Homberger_0400_R1_4_1.vrp", "cvrptw-400customers.xml");
        importer.convert("vrpweb/basic/road-unknown/bays-n29-k5.vrp", "road-cvrp-29customers.xml");
    }

    public VehicleRoutingImporter() {
        super(new VehicleRoutingDao());
    }

    public VehicleRoutingImporter(boolean withoutDao) {
        super(withoutDao);
    }

    @Override
    public String getInputFileSuffix() {
        return "vrp";
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new VehicleRoutingInputBuilder();
    }

    public static class VehicleRoutingInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private VehicleRoutingSolution solution;
        private boolean timewindowed;
        private int customerListSize;
        private int vehicleListSize;
        private int capacity;
        private Map<Long, Location> locationMap;
        private List<Depot> depotList;

        @Override
        public Solution readSolution() throws IOException {
            String firstLine = this.readStringValue();
            if (firstLine.matches("\\s*NAME\\s*:.*")) {
                this.solution = new VehicleRoutingSolution();
                this.solution.setId(0L);
                this.solution.setName(this.removePrefixSuffixFromLine(firstLine, "\\s*NAME\\s*:", ""));
                this.readVrpWebFormat();
            } else if (this.splitBySpacesOrTabs(firstLine).length == 3) {
                this.timewindowed = false;
                this.solution = new VehicleRoutingSolution();
                this.solution.setId(0L);
                this.solution.setName(FilenameUtils.getBaseName((String)this.inputFile.getName()));
                String[] tokens = this.splitBySpacesOrTabs(firstLine, 3);
                this.customerListSize = Integer.parseInt(tokens[0]);
                this.vehicleListSize = Integer.parseInt(tokens[1]);
                this.capacity = Integer.parseInt(tokens[2]);
                this.readCourseraFormat();
            } else {
                this.timewindowed = true;
                this.solution = new TimeWindowedVehicleRoutingSolution();
                this.solution.setId(0L);
                this.solution.setName(firstLine);
                this.readTimeWindowedFormat();
            }
            BigInteger possibleSolutionSize = this.factorial(this.customerListSize + this.vehicleListSize - 1).divide(this.factorial(this.vehicleListSize - 1));
            this.logger.info("VehicleRoutingSolution {} has {} depots, {} vehicles and {} customers with a search space of {}.", new Object[]{this.getInputId(), this.solution.getDepotList().size(), this.solution.getVehicleList().size(), this.solution.getCustomerList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.solution;
        }

        public void readVrpWebFormat() throws IOException {
            this.readVrpWebHeaders();
            this.readVrpWebLocationList();
            this.readVrpWebCustomerList();
            this.readVrpWebDepotList();
            this.createVrpWebVehicleList();
            this.readConstantLine("EOF");
        }

        private void readVrpWebHeaders() throws IOException {
            String edgeWeightFormat;
            this.skipOptionalConstantLines("COMMENT *:.*");
            String vrpType = this.readStringValue("TYPE *:");
            if (vrpType.equals("CVRP")) {
                this.timewindowed = false;
            } else if (vrpType.equals("CVRPTW")) {
                this.timewindowed = true;
                Long solutionId = this.solution.getId();
                String solutionName = this.solution.getName();
                this.solution = new TimeWindowedVehicleRoutingSolution();
                this.solution.setId(solutionId);
                this.solution.setName(solutionName);
            } else {
                throw new IllegalArgumentException("The vrpType (" + vrpType + ") is not supported.");
            }
            this.customerListSize = this.readIntegerValue("DIMENSION *:");
            String edgeWeightType = this.readStringValue("EDGE_WEIGHT_TYPE *:");
            if (edgeWeightType.equalsIgnoreCase("EUC_2D")) {
                this.solution.setDistanceType(DistanceType.AIR_DISTANCE);
            } else if (edgeWeightType.equalsIgnoreCase("EXPLICIT")) {
                this.solution.setDistanceType(DistanceType.ROAD_DISTANCE);
                edgeWeightFormat = this.readStringValue("EDGE_WEIGHT_FORMAT *:");
                if (!edgeWeightFormat.equalsIgnoreCase("FULL_MATRIX")) {
                    throw new IllegalArgumentException("The edgeWeightFormat (" + edgeWeightFormat + ") is not supported.");
                }
            } else if (edgeWeightType.equalsIgnoreCase("SEGMENTED_EXPLICIT")) {
                this.solution.setDistanceType(DistanceType.SEGMENTED_ROAD_DISTANCE);
                edgeWeightFormat = this.readStringValue("EDGE_WEIGHT_FORMAT *:");
                if (!edgeWeightFormat.equalsIgnoreCase("HUB_AND_NEARBY_MATRIX")) {
                    throw new IllegalArgumentException("The edgeWeightFormat (" + edgeWeightFormat + ") is not supported.");
                }
            } else {
                throw new IllegalArgumentException("The edgeWeightType (" + edgeWeightType + ") is not supported.");
            }
            this.solution.setDistanceUnitOfMeasurement(this.readOptionalStringValue("EDGE_WEIGHT_UNIT_OF_MEASUREMENT *:", "distance"));
            this.capacity = this.readIntegerValue("CAPACITY *:");
        }

        private void readVrpWebLocationList() throws IOException {
            ArrayList<Location> locationList;
            Location location;
            String[] lineTokens;
            String line;
            int i;
            DistanceType distanceType = this.solution.getDistanceType();
            ArrayList<Location> hubLocationList = null;
            this.locationMap = new LinkedHashMap<Long, Location>(this.customerListSize);
            if (distanceType == DistanceType.SEGMENTED_ROAD_DISTANCE) {
                int hubListSize = this.readIntegerValue("HUBS *:");
                hubLocationList = new ArrayList<Location>(hubListSize);
                this.readConstantLine("HUB_COORD_SECTION");
                for (i = 0; i < hubListSize; ++i) {
                    line = this.bufferedReader.readLine();
                    lineTokens = this.splitBySpacesOrTabs(line.trim(), 3, 4);
                    location = new HubSegmentLocation();
                    location.setId(Long.parseLong(lineTokens[0]));
                    location.setLatitude(Double.parseDouble(lineTokens[1]));
                    location.setLongitude(Double.parseDouble(lineTokens[2]));
                    if (lineTokens.length >= 4) {
                        location.setName(lineTokens[3]);
                    }
                    hubLocationList.add(location);
                    this.locationMap.put(location.getId(), location);
                }
            }
            ArrayList<Location> customerLocationList = new ArrayList<Location>(this.customerListSize);
            this.readConstantLine("NODE_COORD_SECTION");
            for (i = 0; i < this.customerListSize; ++i) {
                line = this.bufferedReader.readLine();
                lineTokens = this.splitBySpacesOrTabs(line.trim(), 3, 4);
                switch (distanceType) {
                    case AIR_DISTANCE: {
                        location = new AirLocation();
                        break;
                    }
                    case ROAD_DISTANCE: {
                        location = new RoadLocation();
                        break;
                    }
                    case SEGMENTED_ROAD_DISTANCE: {
                        location = new RoadSegmentLocation();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The distanceType (" + (Object)((Object)distanceType) + ") is not implemented.");
                    }
                }
                location.setId(Long.parseLong(lineTokens[0]));
                location.setLatitude(Double.parseDouble(lineTokens[1]));
                location.setLongitude(Double.parseDouble(lineTokens[2]));
                if (lineTokens.length >= 4) {
                    location.setName(lineTokens[3]);
                }
                customerLocationList.add(location);
                this.locationMap.put(location.getId(), location);
            }
            if (distanceType == DistanceType.ROAD_DISTANCE) {
                this.readConstantLine("EDGE_WEIGHT_SECTION");
                for (i = 0; i < this.customerListSize; ++i) {
                    RoadLocation location2 = (RoadLocation)customerLocationList.get(i);
                    LinkedHashMap<RoadLocation, Double> travelDistanceMap = new LinkedHashMap<RoadLocation, Double>(this.customerListSize);
                    String line2 = this.bufferedReader.readLine();
                    String[] lineTokens2 = this.splitBySpacesOrTabs(line2.trim(), this.customerListSize);
                    for (int j = 0; j < this.customerListSize; ++j) {
                        double travelDistance = Double.parseDouble(lineTokens2[j]);
                        if (i == j) {
                            if (travelDistance == 0.0) continue;
                            throw new IllegalStateException("The travelDistance (" + travelDistance + ") should be zero.");
                        }
                        RoadLocation otherLocation = (RoadLocation)customerLocationList.get(j);
                        travelDistanceMap.put(otherLocation, travelDistance);
                    }
                    location2.setTravelDistanceMap(travelDistanceMap);
                }
            }
            if (distanceType == DistanceType.SEGMENTED_ROAD_DISTANCE) {
                this.readConstantLine("SEGMENTED_EDGE_WEIGHT_SECTION");
                int locationListSize = hubLocationList.size() + this.customerListSize;
                for (int i2 = 0; i2 < locationListSize; ++i2) {
                    String line3 = this.bufferedReader.readLine();
                    String[] lineTokens3 = this.splitBySpacesOrTabs(line3.trim(), 3, null);
                    if (lineTokens3.length % 2 != 1) {
                        throw new IllegalArgumentException("Invalid SEGMENTED_EDGE_WEIGHT_SECTION line (" + line3 + ").");
                    }
                    long id = Long.parseLong(lineTokens3[0]);
                    Location location3 = this.locationMap.get(id);
                    if (location3 == null) {
                        throw new IllegalArgumentException("The location with id (" + id + ") of line (" + line3 + ") does not exist.");
                    }
                    LinkedHashMap<HubSegmentLocation, Double> hubTravelDistanceMap = new LinkedHashMap<HubSegmentLocation, Double>(lineTokens3.length / 2);
                    LinkedHashMap<RoadSegmentLocation, Double> nearbyTravelDistanceMap = new LinkedHashMap<RoadSegmentLocation, Double>(lineTokens3.length / 2);
                    for (int j = 1; j < lineTokens3.length; j += 2) {
                        Location otherLocation = this.locationMap.get(Long.parseLong(lineTokens3[j]));
                        double travelDistance = Double.parseDouble(lineTokens3[j + 1]);
                        if (otherLocation instanceof HubSegmentLocation) {
                            hubTravelDistanceMap.put((HubSegmentLocation)otherLocation, travelDistance);
                            continue;
                        }
                        nearbyTravelDistanceMap.put((RoadSegmentLocation)otherLocation, travelDistance);
                    }
                    if (location3 instanceof HubSegmentLocation) {
                        HubSegmentLocation hubSegmentLocation = (HubSegmentLocation)location3;
                        hubSegmentLocation.setHubTravelDistanceMap(hubTravelDistanceMap);
                        hubSegmentLocation.setNearbyTravelDistanceMap(nearbyTravelDistanceMap);
                        continue;
                    }
                    RoadSegmentLocation roadSegmentLocation = (RoadSegmentLocation)location3;
                    roadSegmentLocation.setHubTravelDistanceMap(hubTravelDistanceMap);
                    roadSegmentLocation.setNearbyTravelDistanceMap(nearbyTravelDistanceMap);
                }
            }
            if (distanceType == DistanceType.SEGMENTED_ROAD_DISTANCE) {
                locationList = new ArrayList(hubLocationList.size() + this.customerListSize);
                locationList.addAll(hubLocationList);
                locationList.addAll(customerLocationList);
            } else {
                locationList = customerLocationList;
            }
            this.solution.setLocationList(locationList);
        }

        private void readVrpWebCustomerList() throws IOException {
            this.readConstantLine("DEMAND_SECTION");
            this.depotList = new ArrayList<Depot>(this.customerListSize);
            ArrayList<Customer> customerList = new ArrayList<Customer>(this.customerListSize);
            for (int i = 0; i < this.customerListSize; ++i) {
                Location location;
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), this.timewindowed ? 5 : 2);
                long id = Long.parseLong(lineTokens[0]);
                int demand = Integer.parseInt(lineTokens[1]);
                if (demand == 0) {
                    Depot depot = this.timewindowed ? new TimeWindowedDepot() : new Depot();
                    depot.setId(id);
                    location = this.locationMap.get(id);
                    if (location == null) {
                        throw new IllegalArgumentException("The depot with id (" + id + ") has no location (" + location + ").");
                    }
                    depot.setLocation(location);
                    if (this.timewindowed) {
                        TimeWindowedDepot timeWindowedDepot = (TimeWindowedDepot)depot;
                        timeWindowedDepot.setReadyTime(Long.parseLong(lineTokens[2]));
                        timeWindowedDepot.setDueTime(Long.parseLong(lineTokens[3]));
                        long serviceDuration = Long.parseLong(lineTokens[4]);
                        if (serviceDuration != 0L) {
                            throw new IllegalArgumentException("The depot with id (" + id + ") has a serviceDuration (" + serviceDuration + ") that is not 0.");
                        }
                    }
                    this.depotList.add(depot);
                    continue;
                }
                Customer customer = this.timewindowed ? new TimeWindowedCustomer() : new Customer();
                customer.setId(id);
                location = this.locationMap.get(id);
                if (location == null) {
                    throw new IllegalArgumentException("The customer with id (" + id + ") has no location (" + location + ").");
                }
                customer.setLocation(location);
                customer.setDemand(demand);
                if (this.timewindowed) {
                    TimeWindowedCustomer timeWindowedCustomer = (TimeWindowedCustomer)customer;
                    timeWindowedCustomer.setReadyTime(Long.parseLong(lineTokens[2]));
                    timeWindowedCustomer.setDueTime(Long.parseLong(lineTokens[3]));
                    timeWindowedCustomer.setServiceDuration(Long.parseLong(lineTokens[4]));
                }
                customerList.add(customer);
            }
            this.solution.setCustomerList(customerList);
            this.solution.setDepotList(this.depotList);
        }

        private void readVrpWebDepotList() throws IOException {
            this.readConstantLine("DEPOT_SECTION");
            int depotCount = 0;
            long id = this.readLongValue();
            while (id != -1L) {
                ++depotCount;
                id = this.readLongValue();
            }
            if (depotCount != this.depotList.size()) {
                throw new IllegalStateException("The number of demands with 0 demand (" + this.depotList.size() + ") differs from the number of depots (" + depotCount + ").");
            }
        }

        private void createVrpWebVehicleList() throws IOException {
            String inputFileName = this.inputFile.getName();
            if (inputFileName.toLowerCase().startsWith("tutorial")) {
                this.vehicleListSize = this.readIntegerValue("VEHICLES *:");
            } else {
                String inputFileNameRegex = "^.+\\-k(\\d+)\\.vrp$";
                if (!inputFileName.matches(inputFileNameRegex)) {
                    throw new IllegalArgumentException("The inputFileName (" + inputFileName + ") does not match the inputFileNameRegex (" + inputFileNameRegex + ").");
                }
                String vehicleListSizeString = inputFileName.replaceAll(inputFileNameRegex, "$1");
                try {
                    this.vehicleListSize = Integer.parseInt(vehicleListSizeString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("The inputFileName (" + inputFileName + ") has a vehicleListSizeString (" + vehicleListSizeString + ") that is not a number.", e);
                }
            }
            this.createVehicleList();
        }

        private void createVehicleList() {
            ArrayList<Vehicle> vehicleList = new ArrayList<Vehicle>(this.vehicleListSize);
            long id = 0L;
            for (int i = 0; i < this.vehicleListSize; ++i) {
                Vehicle vehicle = new Vehicle();
                vehicle.setId(id);
                ++id;
                vehicle.setCapacity(this.capacity);
                vehicle.setDepot(this.depotList.get(0));
                vehicleList.add(vehicle);
            }
            this.solution.setVehicleList(vehicleList);
        }

        public void readCourseraFormat() throws IOException {
            this.solution.setDistanceType(DistanceType.AIR_DISTANCE);
            this.solution.setDistanceUnitOfMeasurement("distance");
            ArrayList<Location> locationList = new ArrayList<Location>(this.customerListSize);
            this.depotList = new ArrayList<Depot>(1);
            ArrayList<Customer> customerList = new ArrayList<Customer>(this.customerListSize);
            this.locationMap = new LinkedHashMap<Long, Location>(this.customerListSize);
            for (int i = 0; i < this.customerListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), 3, 4);
                AirLocation location = new AirLocation();
                location.setId(Long.valueOf(i));
                location.setLatitude(Double.parseDouble(lineTokens[1]));
                location.setLongitude(Double.parseDouble(lineTokens[2]));
                if (lineTokens.length >= 4) {
                    location.setName(lineTokens[3]);
                }
                locationList.add(location);
                if (i == 0) {
                    Depot depot = new Depot();
                    depot.setId(Long.valueOf(i));
                    depot.setLocation(location);
                    this.depotList.add(depot);
                    continue;
                }
                Customer customer = new Customer();
                customer.setId(Long.valueOf(i));
                customer.setLocation(location);
                int demand = Integer.parseInt(lineTokens[0]);
                customer.setDemand(demand);
                if (demand == 0) continue;
                customerList.add(customer);
            }
            this.solution.setLocationList(locationList);
            this.solution.setDepotList(this.depotList);
            this.solution.setCustomerList(customerList);
            this.createVehicleList();
        }

        public void readTimeWindowedFormat() throws IOException {
            this.readTimeWindowedHeaders();
            this.readTimeWindowedDepotAndCustomers();
            this.createVehicleList();
        }

        private void readTimeWindowedHeaders() throws IOException {
            this.solution.setDistanceType(DistanceType.AIR_DISTANCE);
            this.solution.setDistanceUnitOfMeasurement("distance");
            this.readEmptyLine();
            this.readConstantLine("VEHICLE");
            this.readConstantLine("NUMBER +CAPACITY");
            String[] lineTokens = this.splitBySpacesOrTabs(this.readStringValue(), 2);
            this.vehicleListSize = Integer.parseInt(lineTokens[0]);
            this.capacity = Integer.parseInt(lineTokens[1]);
            this.readEmptyLine();
            this.readConstantLine("CUSTOMER");
            this.readConstantLine("CUST\\s+NO\\.\\s+XCOORD\\.\\s+YCOORD\\.\\s+DEMAND\\s+READY\\s+TIME\\s+DUE\\s+DATE\\s+SERVICE\\s+TIME");
            this.readEmptyLine();
        }

        private void readTimeWindowedDepotAndCustomers() throws IOException {
            String line = this.bufferedReader.readLine();
            int locationListSizeEstimation = 25;
            ArrayList<Location> locationList = new ArrayList<Location>(locationListSizeEstimation);
            this.depotList = new ArrayList<Depot>(1);
            TimeWindowedDepot depot = null;
            ArrayList<Customer> customerList = new ArrayList<Customer>(locationListSizeEstimation);
            boolean first = true;
            while (line != null && !line.trim().isEmpty()) {
                String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), 7);
                long id = Long.parseLong(lineTokens[0]);
                AirLocation location = new AirLocation();
                location.setId(id);
                location.setLatitude(Double.parseDouble(lineTokens[1]));
                location.setLongitude(Double.parseDouble(lineTokens[2]));
                locationList.add(location);
                int demand = Integer.parseInt(lineTokens[3]);
                long readyTime = Long.parseLong(lineTokens[4]) * 1000L;
                long dueTime = Long.parseLong(lineTokens[5]) * 1000L;
                long serviceDuration = Long.parseLong(lineTokens[6]) * 1000L;
                if (first) {
                    depot = new TimeWindowedDepot();
                    depot.setId(id);
                    depot.setLocation(location);
                    if (demand != 0) {
                        throw new IllegalArgumentException("The depot with id (" + id + ") has a demand (" + demand + ").");
                    }
                    depot.setReadyTime(readyTime);
                    depot.setDueTime(dueTime);
                    if (serviceDuration != 0L) {
                        throw new IllegalArgumentException("The depot with id (" + id + ") has a serviceDuration (" + serviceDuration + ").");
                    }
                    this.depotList.add(depot);
                    first = false;
                } else {
                    TimeWindowedCustomer customer = new TimeWindowedCustomer();
                    customer.setId(id);
                    customer.setLocation(location);
                    customer.setDemand(demand);
                    customer.setReadyTime(readyTime);
                    long maximumDueTime = depot.getDueTime() - serviceDuration - location.getDistanceTo(depot.getLocation());
                    if (dueTime > maximumDueTime) {
                        this.logger.warn("The customer ({})'s dueTime ({}) was automatically reduced to maximumDueTime ({}) because of the depot's dueTime ({}).", new Object[]{customer, dueTime, maximumDueTime, depot.getDueTime()});
                        dueTime = maximumDueTime;
                    }
                    customer.setDueTime(dueTime);
                    customer.setServiceDuration(serviceDuration);
                    if (demand != 0) {
                        customerList.add(customer);
                    }
                }
                line = this.bufferedReader.readLine();
            }
            this.solution.setLocationList(locationList);
            this.solution.setDepotList(this.depotList);
            this.solution.setCustomerList(customerList);
            this.customerListSize = locationList.size();
        }
    }
}

