/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.incremental;

import java.util.Collection;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirector;
import org.optaplanner.core.impl.score.director.incremental.ConstraintMatchAwareIncrementalScoreCalculator;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreCalculator;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreDirectorFactory;

public class IncrementalScoreDirector
extends AbstractScoreDirector<IncrementalScoreDirectorFactory> {
    private final IncrementalScoreCalculator incrementalScoreCalculator;

    public IncrementalScoreDirector(IncrementalScoreDirectorFactory scoreDirectorFactory, boolean constraintMatchEnabledPreference, IncrementalScoreCalculator incrementalScoreCalculator) {
        super(scoreDirectorFactory, constraintMatchEnabledPreference);
        this.incrementalScoreCalculator = incrementalScoreCalculator;
    }

    public IncrementalScoreCalculator getIncrementalScoreCalculator() {
        return this.incrementalScoreCalculator;
    }

    @Override
    public void setWorkingSolution(Solution workingSolution) {
        super.setWorkingSolution(workingSolution);
        if (this.incrementalScoreCalculator instanceof ConstraintMatchAwareIncrementalScoreCalculator) {
            ((ConstraintMatchAwareIncrementalScoreCalculator)this.incrementalScoreCalculator).resetWorkingSolution(workingSolution, this.constraintMatchEnabledPreference);
        } else {
            this.incrementalScoreCalculator.resetWorkingSolution(workingSolution);
        }
    }

    @Override
    public Score calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        Score score = this.incrementalScoreCalculator.calculateScore();
        this.setCalculatedScore(score);
        return score;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabledPreference && this.incrementalScoreCalculator instanceof ConstraintMatchAwareIncrementalScoreCalculator;
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled, this method should not be called.");
        }
        return ((ConstraintMatchAwareIncrementalScoreCalculator)this.incrementalScoreCalculator).getConstraintMatchTotals();
    }

    @Override
    public void beforeEntityAdded(EntityDescriptor entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeEntityAdded(entity);
        super.beforeEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterEntityAdded(EntityDescriptor entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterEntityAdded(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeVariableChanged(entity, variableDescriptor.getVariableName());
        super.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterVariableChanged(entity, variableDescriptor.getVariableName());
        super.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void beforeEntityRemoved(EntityDescriptor entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeEntityRemoved(entity);
        super.beforeEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterEntityRemoved(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
        super.beforeProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void beforeProblemFactChanged(Object problemFact) {
        super.beforeProblemFactChanged(problemFact);
    }

    @Override
    public void afterProblemFactChanged(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemFactChanged(problemFact);
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
        super.beforeProblemFactRemoved(problemFact);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemFactRemoved(problemFact);
    }
}

