/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.FileConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.impl.solver.XStreamXmlSolverFactory;

public class XStreamXmlPlannerBenchmarkFactory
extends PlannerBenchmarkFactory {
    protected final SolverConfigContext solverConfigContext;
    protected XStream xStream;
    protected PlannerBenchmarkConfig plannerBenchmarkConfig = null;

    public XStreamXmlPlannerBenchmarkFactory() {
        this(new SolverConfigContext());
    }

    public XStreamXmlPlannerBenchmarkFactory(SolverConfigContext solverConfigContext) {
        this.solverConfigContext = solverConfigContext;
        this.xStream = XStreamXmlSolverFactory.buildXStream();
        ClassLoader actualClassLoader = solverConfigContext.determineActualClassLoader();
        this.xStream.setClassLoader(actualClassLoader);
        this.xStream.processAnnotations(PlannerBenchmarkConfig.class);
        this.xStream.registerConverter((SingleValueConverter)new FileConverter(){

            public String toString(Object obj) {
                return FilenameUtils.separatorsToUnix((String)((File)obj).getPath());
            }
        });
    }

    public void addXStreamAnnotations(Class ... xStreamAnnotations) {
        this.xStream.processAnnotations(xStreamAnnotations);
    }

    public XStream getXStream() {
        return this.xStream;
    }

    public XStreamXmlPlannerBenchmarkFactory configure(String benchmarkConfigResource) {
        ClassLoader actualClassLoader = this.solverConfigContext.determineActualClassLoader();
        InputStream in = actualClassLoader.getResourceAsStream(benchmarkConfigResource);
        if (in == null) {
            String errorMessage = "The benchmarkConfigResource (" + benchmarkConfigResource + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
            if (benchmarkConfigResource.startsWith("/")) {
                errorMessage = errorMessage + "\nAs from 6.1, a classpath resource should not start with a slash (/). A benchmarkConfigResource now adheres to ClassLoader.getResource(String). Remove the leading slash from the benchmarkConfigResource if you're upgrading from 6.0.";
            }
            throw new IllegalArgumentException(errorMessage);
        }
        try {
            return this.configure(in);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Unmarshalling of benchmarkConfigResource (" + benchmarkConfigResource + ") fails.", e);
        }
    }

    public XStreamXmlPlannerBenchmarkFactory configure(File benchmarkConfigFile) {
        try {
            return this.configure(new FileInputStream(benchmarkConfigFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The benchmarkConfigFile (" + benchmarkConfigFile + ") was not found.", e);
        }
    }

    public XStreamXmlPlannerBenchmarkFactory configure(InputStream in) {
        XStreamXmlPlannerBenchmarkFactory xStreamXmlPlannerBenchmarkFactory;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, "UTF-8");
            xStreamXmlPlannerBenchmarkFactory = this.configure(reader);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)in);
        return xStreamXmlPlannerBenchmarkFactory;
    }

    public XStreamXmlPlannerBenchmarkFactory configure(Reader reader) {
        this.plannerBenchmarkConfig = (PlannerBenchmarkConfig)this.xStream.fromXML(reader);
        return this;
    }

    @Override
    public PlannerBenchmarkConfig getPlannerBenchmarkConfig() {
        if (this.plannerBenchmarkConfig == null) {
            throw new IllegalStateException("The plannerBenchmarkConfig (" + this.plannerBenchmarkConfig + ") is null," + " call configure(...) first.");
        }
        return this.plannerBenchmarkConfig;
    }

    @Override
    public PlannerBenchmark buildPlannerBenchmark() {
        if (this.plannerBenchmarkConfig == null) {
            throw new IllegalStateException("The plannerBenchmarkConfig (" + this.plannerBenchmarkConfig + ") is null," + " call configure(...) first.");
        }
        return this.plannerBenchmarkConfig.buildPlannerBenchmark(this.solverConfigContext);
    }
}

