/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.AbstractLeftTupleSinkAdapter;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.spi.PropagationContext;

public class SingleLeftTupleSinkAdapter
extends AbstractLeftTupleSinkAdapter {
    protected LeftTupleSink sink;
    private LeftTupleSink[] array;

    public SingleLeftTupleSinkAdapter() {
        this(RuleBasePartitionId.MAIN_PARTITION, null);
    }

    public SingleLeftTupleSinkAdapter(RuleBasePartitionId partitionId, LeftTupleSink sink) {
        super(partitionId);
        this.sink = sink;
    }

    @Override
    public void createChildLeftTuplesforQuery(LeftTuple leftTuple, RightTuple rightTuple, boolean leftTupleMemoryEnabled, boolean linkRightTuple) {
        this.sink.createLeftTuple(leftTuple, rightTuple, (Sink)this.sink);
    }

    @Override
    public void modifyChildLeftTuplesforQuery(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple childLeftTuple = rightTuple.getFirstChild();
        childLeftTuple.modifyTuple(context, workingMemory);
    }

    @Override
    public void propagateAssertLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        this.doPropagateAssertLeftTuple(context, workingMemory, this.sink.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, this.sink, leftTupleMemoryEnabled));
    }

    @Override
    public void propagateAssertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        this.doPropagateAssertLeftTuple(context, workingMemory, this.sink.createLeftTuple(tuple, this.sink, context, leftTupleMemoryEnabled));
    }

    @Override
    public void propagateRetractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getFirstChild();
        while (child != null) {
            LeftTuple temp = (LeftTuple)child.getHandleNext();
            child.retractTuple(context, workingMemory);
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    @Override
    public void propagateRetractLeftTupleDestroyRightTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getFirstChild();
        while (child != null) {
            LeftTuple temp = (LeftTuple)child.getHandleNext();
            child.retractTuple(context, workingMemory);
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    @Override
    public void propagateRetractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = rightTuple.getFirstChild();
        while (child != null) {
            LeftTuple temp = child.getRightParentNext();
            child.retractTuple(context, workingMemory);
            child.unlinkFromLeftParent();
            child.unlinkFromRightParent();
            child = temp;
        }
    }

    @Override
    public void createAndPropagateAssertLeftTuple(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled, LeftInputAdapterNode liaNode) {
        LeftTuple lt = this.sink.createLeftTuple(factHandle, this.sink, leftTupleMemoryEnabled);
        lt.setPropagationContext(context);
        this.doPropagateAssertLeftTuple(context, workingMemory, lt);
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        if (this.sink.thisNodeEquals(candidate)) {
            return (BaseNode)((Object)this.sink);
        }
        return null;
    }

    @Override
    public LeftTupleSink[] getSinks() {
        if (this.array == null) {
            this.array = new LeftTupleSink[]{this.sink};
        }
        return this.array;
    }

    @Override
    public LeftTupleSinkNode getFirstLeftTupleSink() {
        return (LeftTupleSinkNode)this.sink;
    }

    @Override
    public LeftTupleSinkNode getLastLeftTupleSink() {
        return (LeftTupleSinkNode)this.sink;
    }

    @Override
    public int size() {
        return this.sink != null ? 1 : 0;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sink = (LeftTupleSink)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sink);
    }

    @Override
    public void doPropagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple, LeftTupleSink sink) {
        sink.assertLeftTuple(leftTuple, context, workingMemory);
    }

    protected void doPropagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple newLeftTuple) {
        this.sink.assertLeftTuple(newLeftTuple, context, workingMemory);
    }

    protected void doPropagateModifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.modifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.doPropagateModifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public LeftTuple propagateModifyChildLeftTuple(LeftTuple childLeftTuple, RightTuple parentRightTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        childLeftTuple.modifyTuple(context, workingMemory);
        childLeftTuple.reAddRight();
        return (LeftTuple)childLeftTuple.getHandleNext();
    }

    @Override
    public LeftTuple propagateModifyChildLeftTuple(LeftTuple childLeftTuple, LeftTuple parentLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        childLeftTuple.modifyTuple(context, workingMemory);
        childLeftTuple.reAddLeft();
        return childLeftTuple.getRightParentNext();
    }

    @Override
    public void propagateModifyChildLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        leftTuple.getFirstChild().modifyTuple(context, workingMemory);
    }

    @Override
    public LeftTuple propagateRetractChildLeftTuple(LeftTuple childLeftTuple, RightTuple parentRightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple temp = (LeftTuple)childLeftTuple.getHandleNext();
        childLeftTuple.retractTuple(context, workingMemory);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return temp;
    }

    @Override
    public LeftTuple propagateRetractChildLeftTuple(LeftTuple childLeftTuple, LeftTuple parentLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple temp = childLeftTuple.getRightParentNext();
        childLeftTuple.retractTuple(context, workingMemory);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return temp;
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.modifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory);
    }
}

