/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.solver.EmptySolverFactory;

public class AbstractSolverFactory<Solution_ extends Solution>
extends SolverFactory<Solution_> {
    protected final SolverConfigContext solverConfigContext;
    protected SolverConfig solverConfig = null;

    public AbstractSolverFactory(SolverConfigContext solverConfigContext) {
        this.solverConfigContext = solverConfigContext;
    }

    @Override
    public SolverConfig getSolverConfig() {
        if (this.solverConfig == null) {
            throw new IllegalStateException("The solverConfig (" + this.solverConfig + ") is null," + " call configure(...) first.");
        }
        return this.solverConfig;
    }

    @Override
    public Solver<Solution_> buildSolver() {
        if (this.solverConfig == null) {
            throw new IllegalStateException("The solverConfig (" + this.solverConfig + ") is null," + " call configure(...) first.");
        }
        return this.solverConfig.buildSolver(this.solverConfigContext);
    }

    @Override
    public SolverFactory<Solution_> cloneSolverFactory() {
        if (this.solverConfig == null) {
            throw new IllegalStateException("The solverConfig (" + this.solverConfig + ") is null," + " call configure(...) first.");
        }
        SolverConfig solverConfigClone = new SolverConfig(this.solverConfig);
        return new EmptySolverFactory(this.solverConfigContext, solverConfigClone);
    }
}

