/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.optaplanner.examples.common.swingui.components.LabeledComboBoxRenderer;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.Shift;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.domain.ShiftType;
import org.optaplanner.examples.nurserostering.domain.WeekendDefinition;
import org.optaplanner.examples.nurserostering.swingui.NurseRosteringPanel;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class EmployeePanel
extends JPanel {
    public static final int WEST_HEADER_WIDTH = 160;
    public static final int EAST_HEADER_WIDTH = 130;
    private final NurseRosteringPanel nurseRosteringPanel;
    private List<ShiftDate> shiftDateList;
    private List<Shift> shiftList;
    private Employee employee;
    private JLabel employeeLabel;
    private JButton deleteButton;
    private JPanel shiftDateListPanel = null;
    private Map<ShiftDate, JPanel> shiftDatePanelMap;
    private Map<Shift, JPanel> shiftPanelMap;
    private JLabel numberOfShiftAssignmentsLabel;
    private Map<ShiftAssignment, JButton> shiftAssignmentButtonMap = new HashMap<ShiftAssignment, JButton>();

    public EmployeePanel(NurseRosteringPanel nurseRosteringPanel, List<ShiftDate> shiftDateList, List<Shift> shiftList, Employee employee) {
        super(new BorderLayout());
        this.nurseRosteringPanel = nurseRosteringPanel;
        this.shiftDateList = shiftDateList;
        this.shiftList = shiftList;
        this.employee = employee;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2), BorderFactory.createLineBorder(Color.BLACK)), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.createUI();
    }

    public Employee getEmployee() {
        return this.employee;
    }

    private String getEmployeeLabel() {
        return this.employee == null ? "Unassigned" : this.employee.getLabel();
    }

    public void setShiftDateListAndShiftList(List<ShiftDate> shiftDateList, List<Shift> shiftList) {
        this.shiftDateList = shiftDateList;
        this.shiftList = shiftList;
        this.resetShiftListPanel();
    }

    private void createUI() {
        JPanel labelAndDeletePanel = new JPanel(new BorderLayout(5, 0));
        if (this.employee != null) {
            labelAndDeletePanel.add((Component)new JLabel(this.nurseRosteringPanel.getEmployeeIcon()), "West");
        }
        this.employeeLabel = new JLabel(this.getEmployeeLabel());
        this.employeeLabel.setEnabled(false);
        labelAndDeletePanel.add((Component)this.employeeLabel, "Center");
        if (this.employee != null) {
            JPanel deletePanel = new JPanel(new BorderLayout());
            this.deleteButton = SwingUtils.makeSmallButton((JButton)new JButton(this.nurseRosteringPanel.getDeleteEmployeeIcon()));
            this.deleteButton.setToolTipText("Delete");
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EmployeePanel.this.nurseRosteringPanel.deleteEmployee(EmployeePanel.this.employee);
                }
            });
            deletePanel.add((Component)this.deleteButton, "North");
            labelAndDeletePanel.add((Component)deletePanel, "East");
        }
        labelAndDeletePanel.setPreferredSize(new Dimension(160, (int)labelAndDeletePanel.getPreferredSize().getHeight()));
        this.add((Component)labelAndDeletePanel, "West");
        this.resetShiftListPanel();
        this.numberOfShiftAssignmentsLabel = new JLabel("0 assignments", 4);
        this.numberOfShiftAssignmentsLabel.setPreferredSize(new Dimension(130, 20));
        this.numberOfShiftAssignmentsLabel.setEnabled(false);
        this.add((Component)this.numberOfShiftAssignmentsLabel, "East");
    }

    public void resetShiftListPanel() {
        JPanel shiftDatePanel;
        if (this.shiftDateListPanel != null) {
            this.remove(this.shiftDateListPanel);
        }
        WeekendDefinition weekendDefinition = this.employee == null ? WeekendDefinition.SATURDAY_SUNDAY : this.employee.getContract().getWeekendDefinition();
        this.shiftDateListPanel = new JPanel(new GridLayout(1, 0));
        this.shiftDatePanelMap = new LinkedHashMap<ShiftDate, JPanel>(this.shiftDateList.size());
        for (ShiftDate shiftDate : this.shiftDateList) {
            Color backgroundColor;
            shiftDatePanel = new JPanel(new GridLayout(1, 0));
            Color color = backgroundColor = weekendDefinition.isWeekend(shiftDate.getDayOfWeek()) ? TangoColorFactory.ALUMINIUM_2 : shiftDatePanel.getBackground();
            if (this.employee != null) {
                if (this.employee.getDayOffRequestMap().containsKey(shiftDate)) {
                    backgroundColor = TangoColorFactory.ALUMINIUM_4;
                } else if (this.employee.getDayOnRequestMap().containsKey(shiftDate)) {
                    backgroundColor = TangoColorFactory.SCARLET_1;
                }
            }
            shiftDatePanel.setBackground(backgroundColor);
            boolean inPlanningWindow = this.nurseRosteringPanel.getNurseRoster().getNurseRosterParametrization().isInPlanningWindow(shiftDate);
            shiftDatePanel.setEnabled(inPlanningWindow);
            shiftDatePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(inPlanningWindow ? TangoColorFactory.ALUMINIUM_6 : TangoColorFactory.ALUMINIUM_3), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.shiftDatePanelMap.put(shiftDate, shiftDatePanel);
            if (this.employee == null) {
                JPanel wrappingShiftDatePanel = new JPanel(new BorderLayout());
                JLabel shiftDateLabel = new JLabel(shiftDate.getLabel(), 0);
                shiftDateLabel.setEnabled(shiftDatePanel.isEnabled());
                wrappingShiftDatePanel.add((Component)shiftDateLabel, "North");
                wrappingShiftDatePanel.add((Component)shiftDatePanel, "Center");
                this.shiftDateListPanel.add(wrappingShiftDatePanel);
                continue;
            }
            this.shiftDateListPanel.add(shiftDatePanel);
        }
        this.shiftPanelMap = new LinkedHashMap<Shift, JPanel>(this.shiftList.size());
        for (Shift shift : this.shiftList) {
            shiftDatePanel = this.shiftDatePanelMap.get(shift.getShiftDate());
            JPanel shiftPanel = new JPanel();
            shiftPanel.setEnabled(shiftDatePanel.isEnabled());
            shiftPanel.setLayout(new BoxLayout(shiftPanel, 1));
            Color backgroundColor = shiftDatePanel.getBackground();
            if (this.employee != null) {
                if (this.employee.getShiftOffRequestMap().containsKey(shift)) {
                    backgroundColor = TangoColorFactory.ALUMINIUM_4;
                } else if (this.employee.getShiftOnRequestMap().containsKey(shift)) {
                    backgroundColor = TangoColorFactory.SCARLET_1;
                }
            }
            shiftPanel.setBackground(backgroundColor);
            shiftPanel.setToolTipText("<html>Date: " + shift.getShiftDate().getLabel() + "<br/>Employee: " + (this.employee == null ? "unassigned" : this.employee.getLabel()) + "</html>");
            this.shiftPanelMap.put(shift, shiftPanel);
            shiftDatePanel.add(shiftPanel);
        }
        this.add((Component)this.shiftDateListPanel, "Center");
    }

    public void addShiftAssignment(ShiftAssignment shiftAssignment) {
        Shift shift = shiftAssignment.getShift();
        JPanel shiftPanel = this.shiftPanelMap.get(shift);
        JButton shiftAssignmentButton = SwingUtils.makeSmallButton((JButton)new JButton(new ShiftAssignmentAction(shiftAssignment)));
        shiftAssignmentButton.setEnabled(shiftPanel.isEnabled());
        if (this.employee != null && (this.employee.getDayOffRequestMap().containsKey(shift.getShiftDate()) || this.employee.getShiftOffRequestMap().containsKey(shift))) {
            shiftAssignmentButton.setForeground(TangoColorFactory.SCARLET_1);
        }
        int colorIndex = shift.getShiftType().getIndex() % TangoColorFactory.SEQUENCE_1.length;
        shiftAssignmentButton.setBackground(TangoColorFactory.SEQUENCE_1[colorIndex]);
        shiftPanel.add(shiftAssignmentButton);
        shiftPanel.repaint();
        this.shiftAssignmentButtonMap.put(shiftAssignment, shiftAssignmentButton);
    }

    public void clearShiftAssignments() {
        for (JPanel shiftPanel : this.shiftPanelMap.values()) {
            shiftPanel.removeAll();
            shiftPanel.repaint();
        }
        this.shiftAssignmentButtonMap.clear();
    }

    public void update() {
        this.numberOfShiftAssignmentsLabel.setText(this.shiftAssignmentButtonMap.size() + " assignments");
    }

    private class ShiftAssignmentAction
    extends AbstractAction {
        private ShiftAssignment shiftAssignment;

        public ShiftAssignmentAction(ShiftAssignment shiftAssignment) {
            super(shiftAssignment.getShift().getShiftType().getCode());
            this.shiftAssignment = shiftAssignment;
            Shift shift = shiftAssignment.getShift();
            ShiftType shiftType = shift.getShiftType();
            this.putValue("ShortDescription", "<html>Date: " + shift.getShiftDate().getLabel() + "<br/>Shift type: " + shiftType.getLabel() + " (from " + shiftType.getStartTimeString() + " to " + shiftType.getEndTimeString() + ")<br/>Employee: " + (EmployeePanel.this.employee == null ? "unassigned" : EmployeePanel.this.employee.getLabel()) + "</html>");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Employee> employeeList = EmployeePanel.this.nurseRosteringPanel.getNurseRoster().getEmployeeList();
            JComboBox<Object> employeeListField = new JComboBox<Object>(employeeList.toArray(new Object[employeeList.size() + 1]));
            LabeledComboBoxRenderer.applyToComboBox(employeeListField);
            employeeListField.setSelectedItem(this.shiftAssignment.getEmployee());
            int result = JOptionPane.showConfirmDialog(EmployeePanel.this.getRootPane(), employeeListField, "Select employee", 2);
            if (result == 0) {
                Employee toEmployee = (Employee)employeeListField.getSelectedItem();
                EmployeePanel.this.nurseRosteringPanel.moveShiftAssignmentToEmployee(this.shiftAssignment, toEmployee);
            }
        }
    }
}

