/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.config.AbstractConfig;

public class ConfigUtils {
    public static <T> T newInstance(Object bean, String propertyName, Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("The " + bean.getClass().getSimpleName() + "'s " + propertyName + " (" + clazz.getName() + ") does not have a public no-arg constructor.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("The " + bean.getClass().getSimpleName() + "'s " + propertyName + " (" + clazz.getName() + ") does not have a public no-arg constructor.", e);
        }
    }

    public static <C extends AbstractConfig<C>> C inheritConfig(C original, C inherited) {
        if (inherited != null) {
            if (original == null) {
                original = inherited.newInstance();
            }
            original.inherit(inherited);
        }
        return original;
    }

    public static <C extends AbstractConfig<C>> List<C> inheritMergeableListConfig(List<C> originalList, List<C> inheritedList) {
        if (inheritedList != null) {
            ArrayList<C> mergedList = new ArrayList<C>(inheritedList.size() + (originalList == null ? 0 : originalList.size()));
            for (AbstractConfig inherited : inheritedList) {
                AbstractConfig copy = inherited.newInstance();
                copy.inherit((AbstractConfig)inherited);
                mergedList.add(copy);
            }
            if (originalList != null) {
                mergedList.addAll(originalList);
            }
            originalList = mergedList;
        }
        return originalList;
    }

    public static <T> T inheritOverwritableProperty(T original, T inherited) {
        if (original != null) {
            return original;
        }
        return inherited;
    }

    public static <T> List<T> inheritMergeableListProperty(List<T> originalList, List<T> inheritedList) {
        if (inheritedList == null) {
            return originalList;
        }
        if (originalList == null) {
            return new ArrayList<T>(inheritedList);
        }
        ArrayList<T> mergedList = new ArrayList<T>(inheritedList);
        mergedList.addAll(originalList);
        return mergedList;
    }

    public static <K, T> Map<K, T> inheritMergeableMapProperty(Map<K, T> originalMap, Map<K, T> inheritedMap) {
        if (inheritedMap == null) {
            return originalMap;
        }
        if (originalMap == null) {
            return inheritedMap;
        }
        LinkedHashMap<K, T> mergedMap = new LinkedHashMap<K, T>(inheritedMap);
        mergedMap.putAll(originalMap);
        return mergedMap;
    }

    public static <T> T mergeProperty(T a, T b) {
        return (T)(ObjectUtils.equals(a, b) ? a : null);
    }

    public static <T> T meldProperty(T a, T b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null && b != null) {
            return b;
        }
        if (a != null && b == null) {
            return a;
        }
        return ConfigUtils.mergeProperty(a, b);
    }

    public static boolean isEmptyCollection(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static int ceilDivide(int dividend, int divisor) {
        if (divisor == 0) {
            throw new ArithmeticException("Cannot divide by zero: " + dividend + "/" + divisor);
        }
        int correction = dividend % divisor == 0 ? 0 : (Integer.signum(dividend) * Integer.signum(divisor) < 0 ? 0 : 1);
        return dividend / divisor + correction;
    }

    public static long floorDivide(long dividend, long divisor) {
        if (divisor == 0L) {
            throw new ArithmeticException("Cannot divide by zero: " + dividend + "/" + divisor);
        }
        int correction = dividend % divisor == 0L ? 0 : (Long.signum(dividend) * Long.signum(divisor) < 0 ? -1 : 0);
        return dividend / divisor + (long)correction;
    }

    private ConfigUtils() {
    }
}

