/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.AbstractConfigurableGraph;
import com.google.common.graph.DirectedNodeAdjacencies;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Network;
import com.google.common.graph.NodeAdjacencies;
import com.google.common.graph.UndirectedNodeAdjacencies;
import java.util.Set;

public final class ImmutableGraph<N>
extends AbstractConfigurableGraph<N> {
    private ImmutableGraph(Graph<N> graph) {
        super(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph));
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        Preconditions.checkArgument(!(graph instanceof Network), "Input must not implement common.graph.Network");
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ImmutableGraph<N>(graph);
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    private static <N> ImmutableMap<N, NodeAdjacencies<N>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, NodeAdjacencies<N>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.nodeConnectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N> NodeAdjacencies<N> nodeConnectionsOf(Graph<N> graph, N node) {
        return graph.isDirected() ? DirectedNodeAdjacencies.ofImmutable(ImmutableGraph.createAdjacencyMap(graph, node), graph.predecessors(node).size(), graph.successors(node).size()) : UndirectedNodeAdjacencies.ofImmutable(graph.adjacentNodes(node));
    }

    private static <N> ImmutableMap<N, DirectedNodeAdjacencies.Adjacency> createAdjacencyMap(Graph<N> graph, N node) {
        Set<N> predecessors = graph.predecessors(node);
        Set<N> successors = graph.successors(node);
        ImmutableMap.Builder<N, DirectedNodeAdjacencies.Adjacency> nodeAdjacencies = ImmutableMap.builder();
        for (N adjacentNode : graph.adjacentNodes(node)) {
            nodeAdjacencies.put(adjacentNode, ImmutableGraph.getAdjacency(predecessors.contains(adjacentNode), successors.contains(adjacentNode)));
        }
        return nodeAdjacencies.build();
    }

    private static DirectedNodeAdjacencies.Adjacency getAdjacency(boolean isPredecessor, boolean isSuccesor) {
        if (isPredecessor && isSuccesor) {
            return DirectedNodeAdjacencies.Adjacency.BOTH;
        }
        if (isPredecessor) {
            return DirectedNodeAdjacencies.Adjacency.PRED;
        }
        if (isSuccesor) {
            return DirectedNodeAdjacencies.Adjacency.SUCC;
        }
        throw new IllegalStateException();
    }
}

