/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.graph.ConfigurableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import java.util.Comparator;

public final class NetworkBuilder<N, E> {
    final boolean directed;
    boolean allowsParallelEdges = false;
    boolean allowsSelfLoops = true;
    Comparator<N> nodeComparator = null;
    Comparator<E> edgeComparator = null;
    Optional<Integer> expectedNodeCount = Optional.absent();
    Optional<Integer> expectedEdgeCount = Optional.absent();

    private NetworkBuilder(boolean directed) {
        this.directed = directed;
    }

    public static NetworkBuilder<Object, Object> directed() {
        return new NetworkBuilder<Object, Object>(true);
    }

    public static NetworkBuilder<Object, Object> undirected() {
        return new NetworkBuilder<Object, Object>(false);
    }

    public static <N, E> NetworkBuilder<N, E> from(Network<N, E> graph) {
        return new NetworkBuilder<N, E>(graph.isDirected()).allowsParallelEdges(graph.allowsParallelEdges()).allowsSelfLoops(graph.allowsSelfLoops());
    }

    public NetworkBuilder<N, E> allowsParallelEdges(boolean allowsParallelEdges) {
        this.allowsParallelEdges = allowsParallelEdges;
        return this;
    }

    public NetworkBuilder<N, E> allowsSelfLoops(boolean allowsSelfLoops) {
        this.allowsSelfLoops = allowsSelfLoops;
        return this;
    }

    public NetworkBuilder<N, E> expectedNodeCount(int expectedNodeCount) {
        Preconditions.checkArgument(expectedNodeCount >= 0, "The expected number of nodes can't be negative: %s", expectedNodeCount);
        this.expectedNodeCount = Optional.of(expectedNodeCount);
        return this;
    }

    public NetworkBuilder<N, E> expectedEdgeCount(int expectedEdgeCount) {
        Preconditions.checkArgument(expectedEdgeCount >= 0, "The expected number of edges can't be negative: %s", expectedEdgeCount);
        this.expectedEdgeCount = Optional.of(expectedEdgeCount);
        return this;
    }

    public <N1 extends N, E1 extends E> MutableNetwork<N1, E1> build() {
        return new ConfigurableNetwork(this);
    }
}

