/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.core.impl.solver.XStreamXmlSolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkResultIO {
    private static final String PLANNER_BENCHMARK_RESULT_FILENAME = "plannerBenchmarkResult.xml";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final XStream xStream = XStreamXmlSolverFactory.buildXStream();

    public BenchmarkResultIO() {
        this.xStream.processAnnotations(PlannerBenchmarkResult.class);
    }

    public void writePlannerBenchmarkResult(File benchmarkReportDirectory, PlannerBenchmarkResult plannerBenchmarkResult) {
        File plannerBenchmarkResultFile = new File(benchmarkReportDirectory, PLANNER_BENCHMARK_RESULT_FILENAME);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(plannerBenchmarkResultFile), "UTF-8");){
            this.xStream.toXML((Object)plannerBenchmarkResult, (Writer)writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed writing plannerBenchmarkResultFile (" + plannerBenchmarkResultFile + ").", e);
        }
    }

    public List<PlannerBenchmarkResult> readPlannerBenchmarkResultList(File benchmarkDirectory) {
        if (!benchmarkDirectory.exists()) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + benchmarkDirectory + ") does not exist.");
        }
        if (!benchmarkDirectory.isDirectory()) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + benchmarkDirectory + ") is not a directory.");
        }
        Object[] benchmarkReportDirectories = benchmarkDirectory.listFiles((FileFilter)DirectoryFileFilter.INSTANCE);
        Arrays.sort(benchmarkReportDirectories);
        ArrayList<PlannerBenchmarkResult> plannerBenchmarkResultList = new ArrayList<PlannerBenchmarkResult>(benchmarkReportDirectories.length);
        for (Object benchmarkReportDirectory : benchmarkReportDirectories) {
            File plannerBenchmarkResultFile = new File((File)benchmarkReportDirectory, PLANNER_BENCHMARK_RESULT_FILENAME);
            if (!plannerBenchmarkResultFile.exists()) continue;
            PlannerBenchmarkResult plannerBenchmarkResult = this.readPlannerBenchmarkResult(plannerBenchmarkResultFile);
            plannerBenchmarkResultList.add(plannerBenchmarkResult);
        }
        return plannerBenchmarkResultList;
    }

    protected PlannerBenchmarkResult readPlannerBenchmarkResult(File plannerBenchmarkResultFile) {
        PlannerBenchmarkResult plannerBenchmarkResult;
        if (!plannerBenchmarkResultFile.exists()) {
            throw new IllegalArgumentException("The plannerBenchmarkResultFile (" + plannerBenchmarkResultFile + ") does not exist.");
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(plannerBenchmarkResultFile), "UTF-8");){
            plannerBenchmarkResult = (PlannerBenchmarkResult)this.xStream.fromXML((Reader)reader);
        }
        catch (ConversionException e) {
            this.logger.warn("Failed reading plannerBenchmarkResultFile (" + plannerBenchmarkResultFile + ").", (Throwable)e);
            String benchmarkReportDirectoryName = plannerBenchmarkResultFile.getParentFile().getName();
            plannerBenchmarkResult = PlannerBenchmarkResult.createUnmarshallingFailedResult(benchmarkReportDirectoryName);
        }
        catch (XStreamException | IOException e) {
            throw new IllegalArgumentException("Failed reading plannerBenchmarkResultFile (" + plannerBenchmarkResultFile + ").", e);
        }
        plannerBenchmarkResult.setBenchmarkReportDirectory(plannerBenchmarkResultFile.getParentFile());
        this.restoreOmittedBidirectionalFields(plannerBenchmarkResult);
        return plannerBenchmarkResult;
    }

    private void restoreOmittedBidirectionalFields(PlannerBenchmarkResult plannerBenchmarkResult) {
        for (ProblemBenchmarkResult problemBenchmarkResult : plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
            problemBenchmarkResult.setPlannerBenchmarkResult(plannerBenchmarkResult);
            if (problemBenchmarkResult.getProblemStatisticList() == null) {
                problemBenchmarkResult.setProblemStatisticList(new ArrayList<ProblemStatistic>(0));
            }
            for (ProblemStatistic problemStatistic : problemBenchmarkResult.getProblemStatisticList()) {
                problemStatistic.setProblemBenchmarkResult(problemBenchmarkResult);
            }
            for (SingleBenchmarkResult singleBenchmarkResult : problemBenchmarkResult.getSingleBenchmarkResultList()) {
                singleBenchmarkResult.setProblemBenchmarkResult(problemBenchmarkResult);
            }
        }
        for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            solverBenchmarkResult.setPlannerBenchmarkResult(plannerBenchmarkResult);
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                singleBenchmarkResult.setSolverBenchmarkResult(solverBenchmarkResult);
                for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                    if (subSingleBenchmarkResult.getPureSubSingleStatisticList() != null) continue;
                    subSingleBenchmarkResult.setPureSubSingleStatisticList(new ArrayList<PureSubSingleStatistic>(0));
                }
                for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                    for (PureSubSingleStatistic pureSubSingleStatistic : subSingleBenchmarkResult.getPureSubSingleStatisticList()) {
                        pureSubSingleStatistic.setSubSingleBenchmarkResult(subSingleBenchmarkResult);
                    }
                }
            }
        }
    }
}

