/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import java.util.Set;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.taskassigning.domain.Affinity;
import org.optaplanner.examples.taskassigning.domain.Customer;
import org.optaplanner.examples.taskassigning.domain.Skill;
import org.optaplanner.examples.taskassigning.domain.TaskOrEmployee;

@XStreamAlias(value="TaEmployee")
public class Employee
extends TaskOrEmployee
implements Labeled {
    private String fullName;
    private Set<Skill> skillSet;
    private Map<Customer, Affinity> affinityMap;

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Set<Skill> getSkillSet() {
        return this.skillSet;
    }

    public void setSkillSet(Set<Skill> skillSet) {
        this.skillSet = skillSet;
    }

    public Map<Customer, Affinity> getAffinityMap() {
        return this.affinityMap;
    }

    public void setAffinityMap(Map<Customer, Affinity> affinityMap) {
        this.affinityMap = affinityMap;
    }

    @Override
    public Employee getEmployee() {
        return this;
    }

    @Override
    public Integer getEndTime() {
        return 0;
    }

    public Affinity getAffinity(Customer customer) {
        Affinity affinity = this.affinityMap.get(customer);
        if (affinity == null) {
            affinity = Affinity.NONE;
        }
        return affinity;
    }

    @Override
    public String getLabel() {
        return this.fullName;
    }

    public String getToolText() {
        StringBuilder toolText = new StringBuilder();
        toolText.append("<html><center><b>").append(this.fullName).append("</b><br/><br/>");
        toolText.append("Skills:<br/>");
        for (Skill skill : this.skillSet) {
            toolText.append(skill.getLabel()).append("<br/>");
        }
        toolText.append("</center></html>");
        return toolText.toString();
    }

    @Override
    public String toString() {
        return this.fullName;
    }
}

