/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.deciderscorecomparator;

import java.util.Comparator;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.comparator.NaturalScoreComparator;
import org.optaplanner.core.impl.localsearch.decider.deciderscorecomparator.AbstractDeciderScoreComparatorFactory;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.score.comparator.FlatteningHardSoftScoreComparator;

public class ShiftingHardPenaltyDeciderScoreComparatorFactory
extends AbstractDeciderScoreComparatorFactory {
    private int hardScoreActivationThreshold = 0;
    private int successiveNoHardChangeMinimum = 2;
    private int successiveNoHardChangeMaximum = 20;
    private double successiveNoHardChangeRepetitionMultiplicand = 20.0;
    private double hardWeightSurvivalRatio = 0.8;
    private int startingHardWeight = 1000;
    private int successiveNoHardScoreChange;
    private boolean shiftingPenaltyActive;
    private int hardWeight;
    private Comparator<Score> naturalDeciderScoreComparator = new NaturalScoreComparator();

    public void setHardScoreActivationThreshold(int hardScoreActivationThreshold) {
        this.hardScoreActivationThreshold = hardScoreActivationThreshold;
    }

    public void setSuccessiveNoHardChangeMinimum(int successiveNoHardChangeMinimum) {
        this.successiveNoHardChangeMinimum = successiveNoHardChangeMinimum;
    }

    public void setSuccessiveNoHardChangeMaximum(int successiveNoHardChangeMaximum) {
        this.successiveNoHardChangeMaximum = successiveNoHardChangeMaximum;
    }

    public void setSuccessiveNoHardChangeRepetitionMultiplicand(double successiveNoHardChangeRepetitionMultiplicand) {
        this.successiveNoHardChangeRepetitionMultiplicand = successiveNoHardChangeRepetitionMultiplicand;
    }

    public void setHardWeightSurvivalRatio(double hardWeightSurvivalRatio) {
        this.hardWeightSurvivalRatio = hardWeightSurvivalRatio;
    }

    public void setStartingHardWeight(int startingHardWeight) {
        this.startingHardWeight = startingHardWeight;
    }

    public void phaseStarted(LocalSearchPhaseScope phaseScope) {
        this.successiveNoHardScoreChange = 0;
        this.shiftingPenaltyActive = false;
    }

    public void stepEnded(LocalSearchStepScope stepScope) {
        if (stepScope.getBestScoreImproved().booleanValue()) {
            this.successiveNoHardScoreChange = 0;
            this.shiftingPenaltyActive = false;
        } else {
            HardSoftScore lastStepScore = (HardSoftScore)((LocalSearchPhaseScope)stepScope.getPhaseScope()).getLastCompletedStepScope().getScore();
            HardSoftScore stepScore = (HardSoftScore)stepScope.getScore();
            if (stepScore.getHardScore() >= this.hardScoreActivationThreshold && lastStepScore.getHardScore() == stepScore.getHardScore()) {
                ++this.successiveNoHardScoreChange;
            } else {
                --this.successiveNoHardScoreChange;
                if (this.successiveNoHardScoreChange < 0) {
                    this.successiveNoHardScoreChange = 0;
                }
            }
            int min = this.successiveNoHardChangeMinimum;
            int max = this.successiveNoHardChangeMaximum;
            while (true) {
                if (this.successiveNoHardScoreChange < min) {
                    this.shiftingPenaltyActive = false;
                    break;
                }
                if (this.successiveNoHardScoreChange <= max) {
                    this.shiftingPenaltyActive = true;
                    if (this.successiveNoHardScoreChange == min) {
                        this.hardWeight = this.startingHardWeight;
                        break;
                    }
                    this.hardWeight = (int)Math.round((double)this.hardWeight * this.hardWeightSurvivalRatio);
                    break;
                }
                min = (int)Math.round((double)min * this.successiveNoHardChangeRepetitionMultiplicand);
                max = (int)Math.round((double)max * this.successiveNoHardChangeRepetitionMultiplicand);
            }
        }
    }

    @Override
    public Comparator<Score> createDeciderScoreComparator() {
        if (this.shiftingPenaltyActive) {
            return new FlatteningHardSoftScoreComparator(this.hardWeight);
        }
        return this.naturalDeciderScoreComparator;
    }
}

