/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.graph.AbstractGraph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.NodeAdjacencies;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class AbstractConfigurableGraph<N>
extends AbstractGraph<N> {
    private static final int DEFAULT_MAP_SIZE = 11;
    private final boolean isDirected;
    private final boolean allowsSelfLoops;
    protected final Map<N, NodeAdjacencies<N>> nodeConnections;

    AbstractConfigurableGraph(GraphBuilder<? super N> builder) {
        this(builder, Maps.newLinkedHashMapWithExpectedSize(builder.expectedNodeCount.or(11)));
    }

    AbstractConfigurableGraph(GraphBuilder<? super N> builder, Map<N, NodeAdjacencies<N>> nodeConnections) {
        this.isDirected = builder.directed;
        this.allowsSelfLoops = builder.allowsSelfLoops;
        this.nodeConnections = Preconditions.checkNotNull(nodeConnections);
    }

    @Override
    public Set<N> nodes() {
        return Collections.unmodifiableSet(this.nodeConnections.keySet());
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public Set<N> adjacentNodes(Object node) {
        return this.checkedConnections(node).adjacentNodes();
    }

    @Override
    public Set<N> predecessors(Object node) {
        return this.checkedConnections(node).predecessors();
    }

    @Override
    public Set<N> successors(Object node) {
        return this.checkedConnections(node).successors();
    }

    protected NodeAdjacencies<N> checkedConnections(Object node) {
        Preconditions.checkNotNull(node, "node");
        NodeAdjacencies<N> connections = this.nodeConnections.get(node);
        Preconditions.checkArgument(connections != null, "Node %s is not an element of this graph", node);
        return connections;
    }

    protected boolean containsNode(@Nullable Object node) {
        return this.nodeConnections.containsKey(node);
    }
}

