/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.graph.ConfigurableGraph;
import com.google.common.graph.Graph;
import com.google.common.graph.MutableGraph;
import java.util.Comparator;

public final class GraphBuilder<N> {
    final boolean directed;
    boolean allowsSelfLoops = true;
    Comparator<N> nodeComparator = null;
    Optional<Integer> expectedNodeCount = Optional.absent();

    private GraphBuilder(boolean directed) {
        this.directed = directed;
    }

    public static GraphBuilder<Object> directed() {
        return new GraphBuilder<Object>(true);
    }

    public static GraphBuilder<Object> undirected() {
        return new GraphBuilder<Object>(false);
    }

    public static <N> GraphBuilder<N> from(Graph<N> graph) {
        return new GraphBuilder<N>(graph.isDirected()).allowsSelfLoops(graph.allowsSelfLoops());
    }

    public GraphBuilder<N> allowsSelfLoops(boolean allowsSelfLoops) {
        this.allowsSelfLoops = allowsSelfLoops;
        return this;
    }

    public GraphBuilder<N> expectedNodeCount(int expectedNodeCount) {
        Preconditions.checkArgument(expectedNodeCount >= 0, "The expected number of nodes can't be negative: %s", expectedNodeCount);
        this.expectedNodeCount = Optional.of(expectedNodeCount);
        return this;
    }

    public <N1 extends N> MutableGraph<N1> build() {
        return new ConfigurableGraph(this);
    }
}

