/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.graph.AbstractUndirectedNodeConnections;
import com.google.common.graph.SimpleEdgesConnecting;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

final class UndirectedNodeConnections<N, E>
extends AbstractUndirectedNodeConnections<N, E> {
    protected UndirectedNodeConnections(Map<E, N> incidentEdgeMap) {
        super(incidentEdgeMap);
    }

    static <N, E> UndirectedNodeConnections<N, E> of() {
        return new UndirectedNodeConnections(HashBiMap.create(11));
    }

    static <N, E> UndirectedNodeConnections<N, E> ofImmutable(Map<E, N> incidentEdges) {
        return new UndirectedNodeConnections<N, E>(ImmutableBiMap.copyOf(incidentEdges));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(((BiMap)this.incidentEdgeMap).values());
    }

    @Override
    public Set<E> edgesConnecting(Object node) {
        return new SimpleEdgesConnecting(((BiMap)this.incidentEdgeMap).inverse(), node);
    }
}

