/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen;

import java.io.File;
import java.util.Collection;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirector;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionJournal;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenTestWriter;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenerator;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenCorruptedScoreReproducer;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenDroolsExceptionReproducer;

public class TestGenDroolsScoreDirector<Solution_>
extends DroolsScoreDirector<Solution_> {
    private final TestGenKieSessionJournal journal = new TestGenKieSessionJournal();
    private final File testFile = new File("DroolsReproducerTest.java");

    public TestGenDroolsScoreDirector(DroolsScoreDirectorFactory<Solution_> scoreDirectorFactory, boolean constraintMatchEnabledPreference) {
        super(scoreDirectorFactory, constraintMatchEnabledPreference);
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.journal.dispose();
        Collection<Object> workingFacts = this.getWorkingFacts();
        this.journal.addFacts(workingFacts);
        for (Object fact : workingFacts) {
            this.journal.insertInitial(fact);
        }
    }

    @Override
    public Score calculateScore() {
        this.journal.fireAllRules();
        try {
            return super.calculateScore();
        }
        catch (RuntimeException e) {
            TestGenKieSessionJournal minJournal = TestGenerator.minimize(this.journal, new TestGenDroolsExceptionReproducer(e, this.kieSession));
            TestGenTestWriter.print(minJournal, this.testFile);
            throw this.wrapOriginalException(e);
        }
    }

    @Override
    public void assertWorkingScoreFromScratch(Score workingScore, Object completedAction) {
        try {
            super.assertWorkingScoreFromScratch(workingScore, completedAction);
        }
        catch (IllegalStateException e) {
            TestGenCorruptedScoreReproducer reproducer = new TestGenCorruptedScoreReproducer(e.getMessage(), this.kieSession, this.getScoreDefinition(), this.constraintMatchEnabledPreference);
            TestGenKieSessionJournal minJournal = TestGenerator.minimize(this.journal, reproducer);
            TestGenTestWriter.print(minJournal, this.testFile);
            throw this.wrapOriginalException(e);
        }
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        this.journal.fireAllRules();
        return super.getConstraintMatchTotals();
    }

    @Override
    public void dispose() {
        this.journal.dispose();
        super.dispose();
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.journal.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.journal.update(entity, variableDescriptor);
        super.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.journal.delete(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.journal.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.journal.delete(problemFact);
        super.afterProblemFactRemoved(problemFact);
    }

    private RuntimeException wrapOriginalException(RuntimeException e) {
        return new RuntimeException(e.getMessage() + "\nDrools test written to: " + this.testFile.getAbsolutePath(), e);
    }
}

