/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.TreeSet;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionJournal;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestGenTestWriter {
    private static final Logger log = LoggerFactory.getLogger(TestGenTestWriter.class);
    private final TestGenKieSessionJournal journal;
    private final StringBuilder sb;

    public TestGenTestWriter(TestGenKieSessionJournal journal) {
        this.journal = journal;
        this.sb = new StringBuilder(32768);
    }

    static void print(TestGenKieSessionJournal journal, File testFile) {
        new TestGenTestWriter(journal).print(testFile);
    }

    private void print(File testFile) {
        this.printInit();
        this.printSetup();
        this.printTest();
        this.writeTestFile(testFile);
    }

    private void printInit() {
        String domainPackage = null;
        Iterator<TestGenFact> iterator = this.journal.getFacts().iterator();
        while (iterator.hasNext()) {
            Annotation ann;
            int n = 0;
            TestGenFact fact = iterator.next();
            Class<?> factClass = fact.getInstance().getClass();
            Annotation[] annotationArray = factClass.getAnnotations();
            int n2 = annotationArray.length;
            if (n < n2 && PlanningEntity.class.equals((ann = annotationArray[n]).annotationType())) {
                domainPackage = factClass.getPackage().getName();
            }
            if (domainPackage == null) continue;
            break;
        }
        if (domainPackage == null) {
            throw new IllegalStateException("Cannot determine planning domain package.");
        }
        this.sb.append(String.format("package %s;%n%n", domainPackage));
        TreeSet<String> imports = new TreeSet<String>();
        imports.add("org.junit.Before");
        imports.add("org.junit.Test");
        imports.add("org.kie.api.KieServices");
        imports.add("org.kie.api.builder.KieFileSystem");
        imports.add("org.kie.api.builder.model.KieModuleModel");
        imports.add("org.kie.api.io.ResourceType");
        imports.add("org.kie.api.runtime.KieContainer");
        imports.add("org.kie.api.runtime.KieSession");
        for (TestGenFact fact : this.journal.getFacts()) {
            for (Class clazz : fact.getImports()) {
                if (clazz.getPackage().getName().equals(domainPackage)) continue;
                imports.add(clazz.getCanonicalName());
            }
        }
        for (String cls : imports) {
            this.sb.append(String.format("import %s;%n", cls));
        }
        this.sb.append(System.lineSeparator()).append("public class DroolsReproducerTest {").append(System.lineSeparator()).append(System.lineSeparator()).append("    KieSession kieSession;").append(System.lineSeparator());
        for (TestGenFact fact : this.journal.getFacts()) {
            fact.printInitialization(this.sb);
        }
        this.sb.append(System.lineSeparator());
    }

    private void printSetup() {
        this.sb.append("    @Before").append(System.lineSeparator()).append("    public void setUp() {").append(System.lineSeparator()).append("        KieServices kieServices = KieServices.Factory.get();").append(System.lineSeparator()).append("        KieModuleModel kieModuleModel = kieServices.newKieModuleModel();").append(System.lineSeparator()).append("        KieFileSystem kfs = kieServices.newKieFileSystem();").append(System.lineSeparator()).append("        kfs.writeKModuleXML(kieModuleModel.toXML());").append(System.lineSeparator()).append("        kfs.write(kieServices.getResources()").append(System.lineSeparator()).append("                .newClassPathResource(\"org/optaplanner/examples/nurserostering/solver/nurseRosteringScoreRules.drl\")").append(System.lineSeparator()).append("                .setResourceType(ResourceType.DRL));").append(System.lineSeparator()).append("        kieServices.newKieBuilder(kfs).buildAll();").append(System.lineSeparator()).append("        KieContainer kieContainer = kieServices.newKieContainer(kieServices.getRepository().getDefaultReleaseId());").append(System.lineSeparator()).append("        kieSession = kieContainer.newKieSession();").append(System.lineSeparator()).append(System.lineSeparator());
        for (TestGenFact testGenFact : this.journal.getFacts()) {
            testGenFact.printSetup(this.sb);
        }
        this.sb.append(System.lineSeparator());
        for (TestGenKieSessionOperation testGenKieSessionOperation : this.journal.getInitialInserts()) {
            testGenKieSessionOperation.print(this.sb);
        }
        this.sb.append("    }").append(System.lineSeparator()).append(System.lineSeparator());
    }

    private void printTest() {
        this.sb.append("    @Test").append(System.lineSeparator()).append("    public void test() {").append(System.lineSeparator());
        for (TestGenKieSessionOperation op : this.journal.getMoveOperations()) {
            op.print(this.sb);
        }
        this.sb.append("    }").append(System.lineSeparator()).append("}").append(System.lineSeparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTestFile(File file) {
        OutputStreamWriter out;
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            log.error("Cannot open test file: " + file.toString(), (Throwable)ex);
            return;
        }
        try {
            out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error("Can't open", (Throwable)ex);
            return;
        }
        try {
            out.append(this.sb);
        }
        catch (IOException ex) {
            log.error("Can't write", (Throwable)ex);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                log.error("Can't close", (Throwable)ex);
            }
        }
    }
}

