/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleSupport;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.solver.BasicPlumbingTermination;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.core.impl.solver.event.SolverEventSupport;
import org.optaplanner.core.impl.solver.random.RandomFactory;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSolver<Solution_>
implements Solver<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolverEventSupport<Solution_> solverEventSupport = new SolverEventSupport(this);
    protected PhaseLifecycleSupport<Solution_> phaseLifecycleSupport = new PhaseLifecycleSupport();
    protected EnvironmentMode environmentMode;
    protected RandomFactory randomFactory;
    protected boolean constraintMatchEnabledPreference = false;
    protected InnerScoreDirectorFactory<Solution_> scoreDirectorFactory;
    protected BasicPlumbingTermination basicPlumbingTermination;
    protected Termination termination;
    protected BestSolutionRecaller<Solution_> bestSolutionRecaller;
    protected List<Phase> phaseList;
    protected AtomicBoolean solving = new AtomicBoolean(false);
    protected DefaultSolverScope<Solution_> solverScope = new DefaultSolverScope();

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public RandomFactory getRandomFactory() {
        return this.randomFactory;
    }

    public void setRandomFactory(RandomFactory randomFactory) {
        this.randomFactory = randomFactory;
    }

    public boolean isConstraintMatchEnabledPreference() {
        return this.constraintMatchEnabledPreference;
    }

    public void setConstraintMatchEnabledPreference(boolean constraintMatchEnabledPreference) {
        this.constraintMatchEnabledPreference = constraintMatchEnabledPreference;
    }

    @Override
    public InnerScoreDirectorFactory<Solution_> getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    public void setScoreDirectorFactory(InnerScoreDirectorFactory<Solution_> scoreDirectorFactory) {
        this.scoreDirectorFactory = scoreDirectorFactory;
    }

    public void setBasicPlumbingTermination(BasicPlumbingTermination basicPlumbingTermination) {
        this.basicPlumbingTermination = basicPlumbingTermination;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public BestSolutionRecaller<Solution_> getBestSolutionRecaller() {
        return this.bestSolutionRecaller;
    }

    public void setBestSolutionRecaller(BestSolutionRecaller<Solution_> bestSolutionRecaller) {
        this.bestSolutionRecaller = bestSolutionRecaller;
        this.bestSolutionRecaller.setSolverEventSupport(this.solverEventSupport);
    }

    public List<Phase> getPhaseList() {
        return this.phaseList;
    }

    public void setPhaseList(List<Phase> phaseList) {
        this.phaseList = phaseList;
        for (Phase phase : phaseList) {
            phase.setSolverPhaseLifecycleSupport(this.phaseLifecycleSupport);
        }
    }

    public DefaultSolverScope<Solution_> getSolverScope() {
        return this.solverScope;
    }

    @Override
    public Solution_ getBestSolution() {
        return this.solverScope.getBestSolution();
    }

    @Override
    public Score getBestScore() {
        return this.solverScope.getBestScore();
    }

    @Override
    public long getTimeMillisSpent() {
        Long endingSystemTimeMillis = this.solverScope.getEndingSystemTimeMillis();
        if (endingSystemTimeMillis == null) {
            endingSystemTimeMillis = System.currentTimeMillis();
        }
        return endingSystemTimeMillis - this.solverScope.getStartingSystemTimeMillis();
    }

    @Override
    public boolean isSolving() {
        return this.solving.get();
    }

    @Override
    public boolean terminateEarly() {
        return this.basicPlumbingTermination.terminateEarly();
    }

    @Override
    public boolean isTerminateEarly() {
        return this.basicPlumbingTermination.isTerminateEarly();
    }

    @Override
    public boolean addProblemFactChange(ProblemFactChange<Solution_> problemFactChange) {
        return this.basicPlumbingTermination.addProblemFactChange(problemFactChange);
    }

    @Override
    public boolean isEveryProblemFactChangeProcessed() {
        return this.basicPlumbingTermination.isEveryProblemFactChangeProcessed();
    }

    @Override
    public final Solution_ solve(Solution_ planningProblem) {
        if (planningProblem == null) {
            throw new IllegalArgumentException("The planningProblem (" + planningProblem + ") must not be null.");
        }
        this.solverScope.setBestSolution(planningProblem);
        this.outerSolvingStarted(this.solverScope);
        boolean restartSolver = true;
        while (restartSolver) {
            this.solvingStarted(this.solverScope);
            this.runPhases();
            this.solvingEnded(this.solverScope);
            restartSolver = this.checkProblemFactChanges();
        }
        this.outerSolvingEnded(this.solverScope);
        return this.solverScope.getBestSolution();
    }

    public void outerSolvingStarted(DefaultSolverScope<Solution_> solverScope) {
        this.solving.set(true);
        this.basicPlumbingTermination.resetTerminateEarly();
        solverScope.setStartingSolverCount(0);
        solverScope.setWorkingRandom(this.randomFactory.createRandom());
        solverScope.setScoreDirector(this.scoreDirectorFactory.buildScoreDirector(this.constraintMatchEnabledPreference));
    }

    public void solvingStarted(DefaultSolverScope<Solution_> solverScope) {
        solverScope.startingNow();
        solverScope.getScoreDirector().resetCalculationCount();
        solverScope.setWorkingSolutionFromBestSolution();
        this.bestSolutionRecaller.solvingStarted(solverScope);
        this.phaseLifecycleSupport.fireSolvingStarted(solverScope);
        for (Phase phase : this.phaseList) {
            phase.solvingStarted(solverScope);
        }
        int startingSolverCount = solverScope.getStartingSolverCount() + 1;
        solverScope.setStartingSolverCount(startingSolverCount);
        this.logger.info("Solving {}: time spent ({}), best score ({}), environment mode ({}), random ({}).", new Object[]{startingSolverCount == 1 ? "started" : "restarted", solverScope.calculateTimeMillisSpentUpToNow(), solverScope.getBestScore(), this.environmentMode.name(), this.randomFactory != null ? this.randomFactory : "not fixed"});
    }

    protected void runPhases() {
        Iterator<Phase> it = this.phaseList.iterator();
        while (!this.termination.isSolverTerminated(this.solverScope) && it.hasNext()) {
            Phase phase = it.next();
            phase.solve(this.solverScope);
            if (!it.hasNext()) continue;
            this.solverScope.setWorkingSolutionFromBestSolution();
        }
    }

    public void solvingEnded(DefaultSolverScope<Solution_> solverScope) {
        for (Phase phase : this.phaseList) {
            phase.solvingEnded(solverScope);
        }
        this.phaseLifecycleSupport.fireSolvingEnded(solverScope);
        this.bestSolutionRecaller.solvingEnded(solverScope);
        solverScope.endingNow();
    }

    public void outerSolvingEnded(DefaultSolverScope<Solution_> solverScope) {
        solverScope.getScoreDirector().dispose();
        this.logger.info("Solving ended: time spent ({}), best score ({}), score calculation speed ({}/sec), phase total ({}), environment mode ({}).", new Object[]{solverScope.getTimeMillisSpent(), solverScope.getBestScore(), solverScope.getScoreCalculationSpeed(), this.phaseList.size(), this.environmentMode.name()});
        this.solving.set(false);
    }

    private boolean checkProblemFactChanges() {
        boolean restartSolver = this.basicPlumbingTermination.waitForRestartSolverDecision();
        if (!restartSolver) {
            return false;
        }
        BlockingQueue<ProblemFactChange> problemFactChangeQueue = this.basicPlumbingTermination.startProblemFactChangesProcessing();
        this.solverScope.setWorkingSolutionFromBestSolution();
        Score score = null;
        int stepIndex = 0;
        ProblemFactChange problemFactChange = (ProblemFactChange)problemFactChangeQueue.poll();
        while (problemFactChange != null) {
            score = this.doProblemFactChange(problemFactChange, stepIndex);
            ++stepIndex;
            problemFactChange = (ProblemFactChange)problemFactChangeQueue.poll();
        }
        this.basicPlumbingTermination.endProblemFactChangesProcessing();
        Solution_ newBestSolution = this.solverScope.getScoreDirector().cloneWorkingSolution();
        this.bestSolutionRecaller.updateBestSolution(this.solverScope, newBestSolution);
        this.logger.info("Real-time problem fact changes done: step total ({}), new best score ({}).", (Object)stepIndex, (Object)score);
        return true;
    }

    private Score doProblemFactChange(ProblemFactChange<Solution_> problemFactChange, int stepIndex) {
        problemFactChange.doChange(this.solverScope.getScoreDirector());
        Score score = this.solverScope.calculateScore();
        this.logger.debug("    Step index ({}), new score ({}) for real-time problem fact change.", (Object)stepIndex, (Object)score);
        return score;
    }

    @Override
    public void addEventListener(SolverEventListener<Solution_> eventListener) {
        this.solverEventSupport.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(SolverEventListener<Solution_> eventListener) {
        this.solverEventSupport.removeEventListener(eventListener);
    }

    public void addPhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.addEventListener(phaseLifecycleListener);
    }

    public void removePhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.removeEventListener(phaseLifecycleListener);
    }
}

