/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.optional.realtime;

import java.util.Iterator;
import java.util.Objects;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class DeleteProcessProblemFactChange
implements ProblemFactChange<CloudBalance> {
    private final CloudProcess process;

    public DeleteProcessProblemFactChange(CloudProcess process) {
        this.process = process;
    }

    public void doChange(ScoreDirector<CloudBalance> scoreDirector) {
        CloudBalance cloudBalance = (CloudBalance)scoreDirector.getWorkingSolution();
        Iterator<CloudProcess> it = cloudBalance.getProcessList().iterator();
        while (it.hasNext()) {
            CloudProcess workingProcess = it.next();
            if (!Objects.equals(workingProcess, this.process)) continue;
            scoreDirector.beforeEntityRemoved((Object)workingProcess);
            it.remove();
            scoreDirector.afterEntityRemoved((Object)workingProcess);
            break;
        }
        scoreDirector.triggerVariableListeners();
    }
}

