/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.persistence;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.persistence.StringDataGenerator;
import org.optaplanner.examples.meetingscheduling.domain.Attendance;
import org.optaplanner.examples.meetingscheduling.domain.Day;
import org.optaplanner.examples.meetingscheduling.domain.Meeting;
import org.optaplanner.examples.meetingscheduling.domain.MeetingAssignment;
import org.optaplanner.examples.meetingscheduling.domain.MeetingSchedule;
import org.optaplanner.examples.meetingscheduling.domain.Person;
import org.optaplanner.examples.meetingscheduling.domain.PreferredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.RequiredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.Room;
import org.optaplanner.examples.meetingscheduling.domain.TimeGrain;
import org.optaplanner.examples.meetingscheduling.persistence.MeetingSchedulingDao;

public class MeetingSchedulingGenerator
extends LoggingMain {
    private static final StringDataGenerator topicGenerator = new StringDataGenerator().addPart("Strategize", "Fast track", "Cross sell", "Profitize", "Transform", "Engage", "Downsize", "Ramp up", "On board", "Reinvigorate").addPart("data driven", "sales driven", "compelling", "reusable", "negotiated", "sustainable", "laser-focused", "flexible", "real-time", "targeted").addPart("B2B", "e-business", "virtualization", "multitasking", "one stop shop", "braindumps", "data mining", "policies", "synergies", "user experience").addPart("in a nutshell", "in practice", "for dummies", "in action", "recipes", "on the web", "for decision makers", "on the whiteboard", "out of the box", "in the new economy");
    private static final int[] durationInGrainsOptions = new int[]{1, 2, 3, 4, 6, 8, 16};
    private static final int[] personsPerMeetingOptions = new int[]{2, 3, 4, 5, 6, 8, 10, 12, 14, 16, 20, 30};
    private static final int[] startingMinuteOfDayOptions = new int[]{480, 495, 510, 525, 540, 555, 570, 585, 600, 615, 630, 645, 660, 675, 690, 705, 780, 795, 810, 825, 840, 855, 870, 885, 900, 915, 930, 945, 960, 975, 990, 1005, 1020, 1035, 1050, 1065};
    private static final StringDataGenerator fullNameGenerator = StringDataGenerator.build10kFullNames();
    protected final SolutionDao solutionDao = new MeetingSchedulingDao();
    protected final File outputDir = new File(this.solutionDao.getDataDir(), "unsolved");
    protected Random random;

    public static void main(String[] args) {
        new MeetingSchedulingGenerator().generate();
    }

    public void generate() {
        this.writeMeetingSchedule(50, 5);
        this.writeMeetingSchedule(100, 5);
    }

    private void writeMeetingSchedule(int meetingListSize, int roomListSize) {
        int timeGrainListSize = meetingListSize * durationInGrainsOptions[durationInGrainsOptions.length - 1] / roomListSize;
        String fileName = this.determineFileName(meetingListSize, timeGrainListSize, roomListSize);
        File outputFile = new File(this.outputDir, fileName + ".xml");
        MeetingSchedule meetingSchedule = this.createMeetingSchedule(fileName, meetingListSize, timeGrainListSize, roomListSize);
        this.solutionDao.writeSolution(meetingSchedule, outputFile);
    }

    private String determineFileName(int meetingListSize, int timeGrainListSize, int roomListSize) {
        return meetingListSize + "meetings-" + timeGrainListSize + "timegrains-" + roomListSize + "rooms";
    }

    public MeetingSchedule createMeetingSchedule(String fileName, int meetingListSize, int timeGrainListSize, int roomListSize) {
        this.random = new Random(37L);
        topicGenerator.reset();
        fullNameGenerator.reset();
        MeetingSchedule meetingSchedule = new MeetingSchedule();
        meetingSchedule.setId(0L);
        this.createMeetingListAndAttendanceList(meetingSchedule, meetingListSize);
        this.createTimeGrainList(meetingSchedule, timeGrainListSize);
        this.createRoomList(meetingSchedule, roomListSize);
        this.createPersonList(meetingSchedule);
        this.linkAttendanceListToPersons(meetingSchedule);
        this.createMeetingAssignmentList(meetingSchedule);
        BigInteger possibleSolutionSize = BigInteger.valueOf((long)timeGrainListSize * (long)roomListSize).pow(meetingSchedule.getMeetingAssignmentList().size());
        this.logger.info("MeetingSchedule {} has {} meetings, {} timeGrains and {} rooms with a search space of {}.", new Object[]{fileName, meetingListSize, timeGrainListSize, roomListSize, AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
        return meetingSchedule;
    }

    private void createMeetingListAndAttendanceList(MeetingSchedule meetingSchedule, int meetingListSize) {
        ArrayList<Meeting> meetingList = new ArrayList<Meeting>(meetingListSize);
        ArrayList<Attendance> globalAttendanceList = new ArrayList<Attendance>();
        long attendanceId = 0L;
        for (int i = 0; i < meetingListSize; ++i) {
            Meeting meeting = new Meeting();
            meeting.setId(Long.valueOf(i));
            String topic = topicGenerator.generateNextValue();
            meeting.setTopic(topic);
            int durationInGrains = durationInGrainsOptions[this.random.nextInt(durationInGrainsOptions.length)];
            meeting.setDurationInGrains(durationInGrains);
            int attendanceListSize = personsPerMeetingOptions[this.random.nextInt(personsPerMeetingOptions.length)];
            int requiredAttendanceListSize = Math.max(2, this.random.nextInt(attendanceListSize + 1));
            ArrayList<RequiredAttendance> requiredAttendanceList = new ArrayList<RequiredAttendance>(requiredAttendanceListSize);
            for (int j = 0; j < requiredAttendanceListSize; ++j) {
                RequiredAttendance attendance = new RequiredAttendance();
                attendance.setId(attendanceId);
                ++attendanceId;
                attendance.setMeeting(meeting);
                requiredAttendanceList.add(attendance);
                globalAttendanceList.add(attendance);
            }
            meeting.setRequiredAttendanceList(requiredAttendanceList);
            int preferredAttendanceListSize = attendanceListSize - requiredAttendanceListSize;
            ArrayList<PreferredAttendance> preferredAttendanceList = new ArrayList<PreferredAttendance>(preferredAttendanceListSize);
            for (int j = 0; j < preferredAttendanceListSize; ++j) {
                PreferredAttendance attendance = new PreferredAttendance();
                attendance.setId(attendanceId);
                ++attendanceId;
                attendance.setMeeting(meeting);
                preferredAttendanceList.add(attendance);
                globalAttendanceList.add(attendance);
            }
            meeting.setPreferredAttendanceList(preferredAttendanceList);
            this.logger.trace("Created meeting with topic ({}), durationInGrains ({}), requiredAttendanceListSize ({}), preferredAttendanceListSize ({}).", new Object[]{topic, durationInGrains, requiredAttendanceListSize, preferredAttendanceListSize});
            meetingList.add(meeting);
        }
        meetingSchedule.setMeetingList(meetingList);
        meetingSchedule.setAttendanceList(globalAttendanceList);
    }

    private void createTimeGrainList(MeetingSchedule meetingSchedule, int timeGrainListSize) {
        ArrayList<Day> dayList = new ArrayList<Day>(timeGrainListSize);
        long dayId = 0L;
        Day day = null;
        ArrayList<TimeGrain> timeGrainList = new ArrayList<TimeGrain>(timeGrainListSize);
        for (int i = 0; i < timeGrainListSize; ++i) {
            TimeGrain timeGrain = new TimeGrain();
            timeGrain.setId(Long.valueOf(i));
            int grainIndex = i;
            timeGrain.setGrainIndex(grainIndex);
            int dayOfYear = i / startingMinuteOfDayOptions.length + 1;
            if (day == null || day.getDayOfYear() != dayOfYear) {
                day = new Day();
                day.setId(dayId);
                day.setDayOfYear(dayOfYear);
                ++dayId;
                dayList.add(day);
            }
            timeGrain.setDay(day);
            int startingMinuteOfDay = startingMinuteOfDayOptions[i % startingMinuteOfDayOptions.length];
            timeGrain.setStartingMinuteOfDay(startingMinuteOfDay);
            this.logger.trace("Created timeGrain with grainIndex ({}), dayOfYear ({}), startingMinuteOfDay ({}).", new Object[]{grainIndex, dayOfYear, startingMinuteOfDay});
            timeGrainList.add(timeGrain);
        }
        meetingSchedule.setDayList(dayList);
        meetingSchedule.setTimeGrainList(timeGrainList);
    }

    private void createRoomList(MeetingSchedule meetingSchedule, int roomListSize) {
        ArrayList<Room> roomList = new ArrayList<Room>(roomListSize);
        for (int i = 0; i < roomListSize; ++i) {
            Room room = new Room();
            room.setId(Long.valueOf(i));
            int roomsPerFloor = 20;
            String name = "R " + (i / roomsPerFloor * 100 + i % roomsPerFloor + 1);
            room.setName(name);
            int capacityOptionsSubsetSize = personsPerMeetingOptions.length * 3 / 4;
            int capacity = personsPerMeetingOptions[personsPerMeetingOptions.length - i % capacityOptionsSubsetSize - 1];
            room.setCapacity(capacity);
            this.logger.trace("Created room with name ({}), capacity ({}).", (Object)name, (Object)capacity);
            roomList.add(room);
        }
        meetingSchedule.setRoomList(roomList);
    }

    private void createPersonList(MeetingSchedule meetingSchedule) {
        int attendanceListSize = 0;
        for (Meeting meeting : meetingSchedule.getMeetingList()) {
            attendanceListSize += meeting.getRequiredAttendanceList().size() + meeting.getPreferredAttendanceList().size();
        }
        int personListSize = attendanceListSize * meetingSchedule.getRoomList().size() * 3 / (4 * meetingSchedule.getMeetingList().size());
        ArrayList<Person> personList = new ArrayList<Person>(personListSize);
        for (int i = 0; i < personListSize; ++i) {
            Person person = new Person();
            person.setId(Long.valueOf(i));
            String fullName = fullNameGenerator.generateNextValue();
            person.setFullName(fullName);
            this.logger.trace("Created person with fullName ({}).", (Object)fullName);
            personList.add(person);
        }
        meetingSchedule.setPersonList(personList);
    }

    private void linkAttendanceListToPersons(MeetingSchedule meetingSchedule) {
        for (Meeting meeting : meetingSchedule.getMeetingList()) {
            ArrayList<Person> availablePersonList = new ArrayList<Person>(meetingSchedule.getPersonList());
            int attendanceListSize = meeting.getRequiredAttendanceList().size() + meeting.getPreferredAttendanceList().size();
            if (availablePersonList.size() < attendanceListSize) {
                throw new IllegalStateException("The availablePersonList size (" + availablePersonList.size() + ") is less than the attendanceListSize (" + attendanceListSize + ").");
            }
            for (RequiredAttendance requiredAttendance : meeting.getRequiredAttendanceList()) {
                requiredAttendance.setPerson((Person)availablePersonList.remove(this.random.nextInt(availablePersonList.size())));
            }
            for (PreferredAttendance preferredAttendance : meeting.getPreferredAttendanceList()) {
                preferredAttendance.setPerson((Person)availablePersonList.remove(this.random.nextInt(availablePersonList.size())));
            }
        }
    }

    private void createMeetingAssignmentList(MeetingSchedule meetingSchedule) {
        List<Meeting> meetingList = meetingSchedule.getMeetingList();
        ArrayList<MeetingAssignment> meetingAssignmentList = new ArrayList<MeetingAssignment>(meetingList.size());
        for (Meeting meeting : meetingList) {
            MeetingAssignment meetingAssignment = new MeetingAssignment();
            meetingAssignment.setId(meeting.getId());
            meetingAssignment.setMeeting(meeting);
            meetingAssignmentList.add(meetingAssignment);
        }
        meetingSchedule.setMeetingAssignmentList(meetingAssignmentList);
    }
}

