/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoft;

import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;

public final class HardMediumSoftScore
extends AbstractScore<HardMediumSoftScore>
implements FeasibilityScore<HardMediumSoftScore> {
    private static final String HARD_LABEL = "hard";
    private static final String MEDIUM_LABEL = "medium";
    private static final String SOFT_LABEL = "soft";
    private final int hardScore;
    private final int mediumScore;
    private final int softScore;

    public static HardMediumSoftScore parseScore(String scoreString) {
        String[] scoreTokens = HardMediumSoftScore.parseScoreTokens(HardMediumSoftScore.class, scoreString, HARD_LABEL, MEDIUM_LABEL, SOFT_LABEL);
        int initScore = HardMediumSoftScore.parseInitScore(HardMediumSoftScore.class, scoreString, scoreTokens[0]);
        int hardScore = HardMediumSoftScore.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[1]);
        int mediumScore = HardMediumSoftScore.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[2]);
        int softScore = HardMediumSoftScore.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[3]);
        return HardMediumSoftScore.valueOf(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftScore valueOf(int initScore, int hardScore, int mediumScore, int softScore) {
        return new HardMediumSoftScore(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftScore valueOfInitialized(int hardScore, int mediumScore, int softScore) {
        return new HardMediumSoftScore(0, hardScore, mediumScore, softScore);
    }

    private HardMediumSoftScore() {
        super(Integer.MIN_VALUE);
        this.hardScore = Integer.MIN_VALUE;
        this.mediumScore = Integer.MIN_VALUE;
        this.softScore = Integer.MIN_VALUE;
    }

    private HardMediumSoftScore(int initScore, int hardScore, int mediumScore, int softScore) {
        super(initScore);
        this.hardScore = hardScore;
        this.mediumScore = mediumScore;
        this.softScore = softScore;
    }

    public int getHardScore() {
        return this.hardScore;
    }

    public int getMediumScore() {
        return this.mediumScore;
    }

    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardMediumSoftScore toInitializedScore() {
        return this.initScore == 0 ? this : new HardMediumSoftScore(0, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore >= 0;
    }

    @Override
    public HardMediumSoftScore add(HardMediumSoftScore augment) {
        return new HardMediumSoftScore(this.initScore + augment.getInitScore(), this.hardScore + augment.getHardScore(), this.mediumScore + augment.getMediumScore(), this.softScore + augment.getSoftScore());
    }

    @Override
    public HardMediumSoftScore subtract(HardMediumSoftScore subtrahend) {
        return new HardMediumSoftScore(this.initScore - subtrahend.getInitScore(), this.hardScore - subtrahend.getHardScore(), this.mediumScore - subtrahend.getMediumScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardMediumSoftScore multiply(double multiplicand) {
        return new HardMediumSoftScore((int)Math.floor((double)this.initScore * multiplicand), (int)Math.floor((double)this.hardScore * multiplicand), (int)Math.floor((double)this.mediumScore * multiplicand), (int)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardMediumSoftScore divide(double divisor) {
        return new HardMediumSoftScore((int)Math.floor((double)this.initScore / divisor), (int)Math.floor((double)this.hardScore / divisor), (int)Math.floor((double)this.mediumScore / divisor), (int)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public HardMediumSoftScore power(double exponent) {
        return new HardMediumSoftScore((int)Math.floor(Math.pow(this.initScore, exponent)), (int)Math.floor(Math.pow(this.hardScore, exponent)), (int)Math.floor(Math.pow(this.mediumScore, exponent)), (int)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public HardMediumSoftScore negate() {
        return new HardMediumSoftScore(-this.initScore, -this.hardScore, -this.mediumScore, -this.softScore);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.mediumScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardMediumSoftScore) {
            HardMediumSoftScore other = (HardMediumSoftScore)o;
            return this.initScore == other.getInitScore() && this.hardScore == other.getHardScore() && this.mediumScore == other.getMediumScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return (((629 + this.initScore) * 37 + this.hardScore) * 37 + this.mediumScore) * 37 + this.softScore;
    }

    @Override
    public int compareTo(HardMediumSoftScore other) {
        if (this.initScore != other.getInitScore()) {
            return this.initScore < other.getInitScore() ? -1 : 1;
        }
        if (this.hardScore != other.getHardScore()) {
            return this.hardScore < other.getHardScore() ? -1 : 1;
        }
        if (this.mediumScore != other.getMediumScore()) {
            return this.mediumScore < other.getMediumScore() ? -1 : 1;
        }
        return Integer.compare(this.softScore, other.getSoftScore());
    }

    public String toString() {
        return this.getInitPrefix() + this.hardScore + HARD_LABEL + "/" + this.mediumScore + MEDIUM_LABEL + "/" + this.softScore + SOFT_LABEL;
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        return otherScore instanceof HardMediumSoftScore;
    }
}

