/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftdouble;

import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;

public final class HardSoftDoubleScore
extends AbstractScore<HardSoftDoubleScore>
implements FeasibilityScore<HardSoftDoubleScore> {
    private static final String HARD_LABEL = "hard";
    private static final String SOFT_LABEL = "soft";
    private final double hardScore;
    private final double softScore;

    public static HardSoftDoubleScore parseScore(String scoreString) {
        String[] scoreTokens = HardSoftDoubleScore.parseScoreTokens(HardSoftDoubleScore.class, scoreString, HARD_LABEL, SOFT_LABEL);
        int initScore = HardSoftDoubleScore.parseInitScore(HardSoftDoubleScore.class, scoreString, scoreTokens[0]);
        double hardScore = HardSoftDoubleScore.parseLevelAsDouble(HardSoftDoubleScore.class, scoreString, scoreTokens[1]);
        double softScore = HardSoftDoubleScore.parseLevelAsDouble(HardSoftDoubleScore.class, scoreString, scoreTokens[2]);
        return HardSoftDoubleScore.valueOf(initScore, hardScore, softScore);
    }

    public static HardSoftDoubleScore valueOf(int initScore, double hardScore, double softScore) {
        return new HardSoftDoubleScore(initScore, hardScore, softScore);
    }

    public static HardSoftDoubleScore valueOfInitialized(double hardScore, double softScore) {
        return new HardSoftDoubleScore(0, hardScore, softScore);
    }

    private HardSoftDoubleScore() {
        super(Integer.MIN_VALUE);
        this.hardScore = Double.NaN;
        this.softScore = Double.NaN;
    }

    private HardSoftDoubleScore(int initScore, double hardScore, double softScore) {
        super(initScore);
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    public double getHardScore() {
        return this.hardScore;
    }

    public double getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardSoftDoubleScore toInitializedScore() {
        return this.initScore == 0 ? this : new HardSoftDoubleScore(0, this.hardScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore >= 0.0;
    }

    @Override
    public HardSoftDoubleScore add(HardSoftDoubleScore augment) {
        return new HardSoftDoubleScore(this.initScore + augment.getInitScore(), this.hardScore + augment.getHardScore(), this.softScore + augment.getSoftScore());
    }

    @Override
    public HardSoftDoubleScore subtract(HardSoftDoubleScore subtrahend) {
        return new HardSoftDoubleScore(this.initScore - subtrahend.getInitScore(), this.hardScore - subtrahend.getHardScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardSoftDoubleScore multiply(double multiplicand) {
        return new HardSoftDoubleScore((int)Math.floor((double)this.initScore * multiplicand), this.hardScore * multiplicand, this.softScore * multiplicand);
    }

    @Override
    public HardSoftDoubleScore divide(double divisor) {
        return new HardSoftDoubleScore((int)Math.floor((double)this.initScore / divisor), this.hardScore / divisor, this.softScore / divisor);
    }

    @Override
    public HardSoftDoubleScore power(double exponent) {
        return new HardSoftDoubleScore((int)Math.floor(Math.pow(this.initScore, exponent)), Math.pow(this.hardScore, exponent), Math.pow(this.softScore, exponent));
    }

    @Override
    public HardSoftDoubleScore negate() {
        return new HardSoftDoubleScore(-this.initScore, -this.hardScore, -this.softScore);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardSoftDoubleScore) {
            HardSoftDoubleScore other = (HardSoftDoubleScore)o;
            return this.initScore == other.getInitScore() && this.hardScore == other.getHardScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return ((629 + this.initScore) * 37 + Double.valueOf(this.hardScore).hashCode()) * 37 + Double.valueOf(this.softScore).hashCode();
    }

    @Override
    public int compareTo(HardSoftDoubleScore other) {
        if (this.initScore != other.getInitScore()) {
            return this.initScore < other.getInitScore() ? -1 : 1;
        }
        if (this.hardScore != other.getHardScore()) {
            return this.hardScore < other.getHardScore() ? -1 : 1;
        }
        return Double.compare(this.softScore, other.getSoftScore());
    }

    public String toString() {
        return this.getInitPrefix() + this.hardScore + HARD_LABEL + "/" + this.softScore + SOFT_LABEL;
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        return otherScore instanceof HardSoftDoubleScore;
    }
}

