/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionJournal;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.mutation.TestGenHeadCuttingMutator;
import org.optaplanner.core.impl.score.director.drools.testgen.mutation.TestGenRemoveRandomBlockMutator;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionInsert;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionOperation;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionUpdate;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenOriginalProblemReproducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TestGenerator {
    private static final Logger logger = LoggerFactory.getLogger(TestGenerator.class);
    private final TestGenOriginalProblemReproducer reproducer;
    private TestGenKieSessionJournal journal;

    static TestGenKieSessionJournal minimize(TestGenKieSessionJournal journal, TestGenOriginalProblemReproducer reproducer) {
        return new TestGenerator(journal, reproducer).run();
    }

    private TestGenerator(TestGenKieSessionJournal journal, TestGenOriginalProblemReproducer reproducer) {
        this.journal = journal;
        this.reproducer = reproducer;
    }

    private TestGenKieSessionJournal run() {
        logger.info("Creating a minimal test that reproduces following Drools problem: {}", (Object)this.reproducer);
        logger.info("The KIE session journal has {} facts, {} inserts and {} updates.", new Object[]{this.journal.getFacts().size(), this.journal.getInitialInserts().size(), this.journal.getMoveOperations().size()});
        logger.info("Trying to reproduce with the complete KIE session journal...");
        this.assertOriginalExceptionReproduced("Cannot reproduce the original problem even without journal modifications. This is a bug!");
        logger.info("Reproduced.");
        this.dropOldestUpdates();
        this.pruneUpdates();
        this.pruneInserts();
        this.pruneFacts();
        this.assertOriginalExceptionReproduced("Cannot reproduce the original problem after pruning the journal. This is a bug!");
        return this.journal;
    }

    private void dropOldestUpdates() {
        logger.info("Dropping oldest updates...", (Object)this.journal.getMoveOperations().size());
        TestGenHeadCuttingMutator<TestGenKieSessionOperation> m = new TestGenHeadCuttingMutator<TestGenKieSessionOperation>(this.journal.getMoveOperations());
        while (m.canMutate()) {
            long start = System.currentTimeMillis();
            TestGenKieSessionJournal testJournal = new TestGenKieSessionJournal(this.journal.getFacts(), this.journal.getInitialInserts(), m.mutate());
            boolean reproduced = this.reproduce(testJournal);
            double tookSeconds = (double)(System.currentTimeMillis() - start) / 1000.0;
            String outcome = reproduced ? "Reproduced" : "Can't reproduce";
            logger.debug("    {} with journal size: {} (took {}s)", new Object[]{outcome, m.getResult().size(), tookSeconds});
            if (reproduced) continue;
            m.revert();
        }
        this.journal = new TestGenKieSessionJournal(this.journal.getFacts(), this.journal.getInitialInserts(), m.getResult());
        logger.info("{} updates remaining.", (Object)this.journal.getMoveOperations().size());
    }

    private void pruneUpdates() {
        logger.info("Pruning updates...", (Object)this.journal.getMoveOperations().size());
        TestGenRemoveRandomBlockMutator<TestGenKieSessionOperation> m = new TestGenRemoveRandomBlockMutator<TestGenKieSessionOperation>(this.journal.getMoveOperations());
        while (m.canMutate()) {
            logger.debug("    Current journal size: {}", (Object)m.getResult().size());
            TestGenKieSessionJournal testJournal = new TestGenKieSessionJournal(this.journal.getFacts(), this.journal.getInitialInserts(), m.mutate());
            boolean reproduced = this.reproduce(testJournal);
            String outcome = reproduced ? "Reproduced" : "Can't reproduce";
            List<TestGenKieSessionOperation> block = m.getRemovedBlock();
            logger.debug("    {} without block of {} [{} - {}]", new Object[]{outcome, block.size(), block.get(0), block.get(block.size() - 1)});
            if (reproduced) continue;
            m.revert();
        }
        this.journal = new TestGenKieSessionJournal(this.journal.getFacts(), this.journal.getInitialInserts(), m.getResult());
        logger.info("{} updates remaining.", (Object)this.journal.getMoveOperations().size());
    }

    private void pruneInserts() {
        logger.info("Pruning inserts...", (Object)this.journal.getInitialInserts().size());
        TestGenRemoveRandomBlockMutator<TestGenKieSessionInsert> m = new TestGenRemoveRandomBlockMutator<TestGenKieSessionInsert>(this.journal.getInitialInserts());
        while (m.canMutate()) {
            logger.debug("    Current journal size: {}", (Object)m.getResult().size());
            TestGenKieSessionJournal testJournal = new TestGenKieSessionJournal(this.journal.getFacts(), m.mutate(), this.journal.getMoveOperations());
            boolean reproduced = this.reproduce(testJournal);
            String outcome = reproduced ? "Reproduced" : "Can't reproduce";
            List<TestGenKieSessionInsert> block = m.getRemovedBlock();
            logger.debug("    {} without block of {} [{} - {}]", new Object[]{outcome, block.size(), block.get(0), block.get(block.size() - 1)});
            if (reproduced) continue;
            m.revert();
        }
        this.journal = new TestGenKieSessionJournal(this.journal.getFacts(), m.getResult(), this.journal.getMoveOperations());
        logger.info("{} inserts remaining.", (Object)this.journal.getInitialInserts().size());
    }

    private void pruneFacts() {
        logger.info("Pruning {} facts...", (Object)this.journal.getFacts().size());
        ArrayList<TestGenFact> minimal = new ArrayList<TestGenFact>();
        for (TestGenKieSessionInsert insert : this.journal.getInitialInserts()) {
            TestGenerator.addWithDependencies(insert.getFact(), minimal);
        }
        for (TestGenKieSessionOperation op : this.journal.getMoveOperations()) {
            if (!op.getClass().equals(TestGenKieSessionUpdate.class)) continue;
            TestGenFact f = ((TestGenKieSessionUpdate)op).getValue();
            TestGenerator.addWithDependencies(f, minimal);
        }
        this.journal = new TestGenKieSessionJournal(minimal, this.journal.getInitialInserts(), this.journal.getMoveOperations());
        logger.info("{} facts remaining.", (Object)this.journal.getFacts().size());
    }

    private static void addWithDependencies(TestGenFact f, List<TestGenFact> factList) {
        if (factList.contains(f)) {
            return;
        }
        factList.add(f);
        for (TestGenFact dependency : f.getDependencies()) {
            TestGenerator.addWithDependencies(dependency, factList);
        }
    }

    private boolean reproduce(TestGenKieSessionJournal testJournal) {
        return this.reproducer.isReproducible(testJournal);
    }

    private void assertOriginalExceptionReproduced(String message) {
        this.reproducer.assertReproducible(this.journal, message);
    }
}

